/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.utils.img;

import com.google.common.collect.Maps;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.rocoinfo.utils.io.FileUtil;
import com.rocoinfo.utils.text.Charsets;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public final class QrCodeUtil {
    private static final int DEFAULT_WIDTH = 300;
    private static final int DEFAULT_HEIGHT = 300;
    private static final String DEFAULT_FORMAT = "png";
    private static final Integer DEFAULT_MARGIN = 0;
    private static final ErrorCorrectionLevel DEFAULT_ECL = ErrorCorrectionLevel.L;

    private QrCodeUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean generateQRCode(String content, int width, int height, String format, Integer margin, ErrorCorrectionLevel ecl, OutputStream os) {
        ConcurrentMap hint = Maps.newConcurrentMap();
        hint.put(EncodeHintType.CHARACTER_SET, Charsets.UTF_8_NAME);
        hint.put(EncodeHintType.ERROR_CORRECTION, ecl);
        hint.put(EncodeHintType.MARGIN, margin);
        try {
            BitMatrix matrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, width, height, (Map)hint);
            MatrixToImageWriter.writeToStream((BitMatrix)matrix, (String)format, (OutputStream)os);
        }
        catch (Exception e) {
            boolean bl;
            try {
                bl = false;
            }
            catch (Throwable throwable) {
                FileUtil.closeIO(os);
                throw throwable;
            }
            FileUtil.closeIO(os);
            return bl;
        }
        FileUtil.closeIO(os);
        return false;
    }

    public static boolean generateQRCode(String content, OutputStream os) {
        return QrCodeUtil.generateQRCode(content, 300, 300, DEFAULT_FORMAT, DEFAULT_MARGIN, DEFAULT_ECL, os);
    }
}

