/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.utils.net;

import com.google.common.collect.Lists;
import com.rocoinfo.utils.base.ExceptionUtil;
import com.rocoinfo.utils.text.Charsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpUtil {
    private static Logger logger = LoggerFactory.getLogger(HttpUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url, NameValuePair ... parameters) {
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new IllegalArgumentException("get\u8bf7\u6c42\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String respTxt = "";
        HttpClient httpClient = HttpUtil.createHttpClientInstance();
        try {
            if (null != parameters && parameters.length > 0) {
                String encodedParams = HttpUtil.encodeParameters(parameters);
                url = -1 == url.indexOf("?") ? url + "?" + encodedParams : url + "&" + encodedParams;
            }
            HttpGet getMethod = new HttpGet(url);
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(4000).setConnectTimeout(2000).build();
            getMethod.setConfig(requestConfig);
            HttpResponse resp = httpClient.execute((HttpUriRequest)getMethod);
            if (resp.getStatusLine().getStatusCode() == 200) {
                respTxt = EntityUtils.toString((HttpEntity)resp.getEntity(), (String)Charsets.UTF_8_NAME);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("httpGet\u8bf7\u6c42\u5f02\u5e38\uff1a{},\u9519\u8bef\u8be6\u7ec6\u662f\uff1a{}", (Object)url, (Object)ExceptionUtil.stackTraceText(e));
        }
        finally {
            HttpClientUtils.closeQuietly((HttpClient)httpClient);
        }
        return respTxt;
    }

    public static String post(String postUrl, NameValuePair ... parameters) {
        return HttpUtil.postWithResponseCharset(postUrl, null, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postWithResponseCharset(String postUrl, String responseCharset, NameValuePair ... parameters) {
        HttpClient client = HttpUtil.createHttpClientInstance();
        String respResult = null;
        try {
            HttpResponse resp;
            HttpPost httPost = new HttpPost(postUrl);
            if (ArrayUtils.isNotEmpty((Object[])parameters)) {
                ArrayList params = Lists.newArrayList((Object[])parameters);
                httPost.setEntity((HttpEntity)new UrlEncodedFormEntity((List)params, Charsets.UTF_8_NAME));
            }
            if ((resp = client.execute((HttpUriRequest)httPost)).getStatusLine().getStatusCode() == 200) {
                HttpEntity entity = resp.getEntity();
                respResult = StringUtils.isBlank((CharSequence)responseCharset) ? EntityUtils.toString((HttpEntity)entity) : EntityUtils.toString((HttpEntity)entity, (String)responseCharset);
            }
        }
        catch (Exception e) {
            logger.error("http\u8bf7\u6c42\u5f02\u5e38\uff1aurl\uff1a{}\uff0cerror\uff1a{}", (Object)postUrl, (Object)ExceptionUtil.stackTraceText(e));
        }
        finally {
            HttpClientUtils.closeQuietly((HttpClient)client);
        }
        return respResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postJson(String url, String json, Map<String, String> headers) {
        HttpClient client = HttpUtil.createHttpClientInstance();
        HttpPost post = new HttpPost(url);
        String respResult = null;
        Integer statusCode = null;
        try {
            if (!MapUtils.isEmpty(headers)) {
                headers.keySet().forEach(key -> post.addHeader(key, (String)headers.get(key)));
            }
            StringEntity stringEntity = new StringEntity(json, Charsets.UTF_8_NAME);
            stringEntity.setContentEncoding(Charsets.UTF_8_NAME);
            stringEntity.setContentType("application/json");
            post.setEntity((HttpEntity)stringEntity);
            HttpResponse resp = client.execute((HttpUriRequest)post);
            statusCode = resp.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HttpEntity entity = resp.getEntity();
                respResult = EntityUtils.toString((HttpEntity)entity, (String)Charsets.UTF_8_NAME);
            }
            logger.info("HttpUtils#post\u6267\u884c\u7ed3\u675f\uff1a{}, \u72b6\u6001\u7801\u4e3a\uff1a{}, \u8fd4\u56de\u7ed3\u679c\u4e3a\uff1a{}", new Object[]{url, statusCode, respResult});
        }
        catch (Exception ex) {
            logger.error("HttpUtils#post\u6267\u884c\u5f02\u5e38\uff1a{}, \u72b6\u6001\u7801\u4e3a\uff1a{}, \u9519\u8bef\u8be6\u7ec6\u662f\uff1a{}", new Object[]{url, statusCode, ex.getMessage()});
        }
        finally {
            HttpClientUtils.closeQuietly((HttpClient)client);
        }
        return respResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String put(String url, String json, Map<String, String> headers) {
        HttpClient client = HttpUtil.createHttpClientInstance();
        HttpPut put = new HttpPut(url);
        String respResult = null;
        Integer statusCode = null;
        try {
            if (!MapUtils.isEmpty(headers)) {
                headers.keySet().forEach(key -> put.addHeader(key, (String)headers.get(key)));
            }
            StringEntity stringEntity = new StringEntity(json, Charsets.UTF_8_NAME);
            stringEntity.setContentEncoding(Charsets.UTF_8_NAME);
            stringEntity.setContentType("application/json");
            put.setEntity((HttpEntity)stringEntity);
            HttpResponse resp = client.execute((HttpUriRequest)put);
            statusCode = resp.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HttpEntity entity = resp.getEntity();
                respResult = EntityUtils.toString((HttpEntity)entity, (String)Charsets.UTF_8_NAME);
            }
            logger.info("HttpUtils#put\u6267\u884c\u7ed3\u675f\uff1a{}, \u72b6\u6001\u7801\u4e3a\uff1a{}, \u8fd4\u56de\u7ed3\u679c\u4e3a\uff1a{}", new Object[]{url, statusCode, respResult});
        }
        catch (Exception ex) {
            logger.error("HttpUtils#put\u6267\u884c\u5f02\u5e38\uff1a{}, \u72b6\u6001\u7801\u4e3a\uff1a{}, \u9519\u8bef\u8be6\u7ec6\u662f\uff1a{}", new Object[]{url, statusCode, ex.getMessage()});
        }
        finally {
            HttpClientUtils.closeQuietly((HttpClient)client);
        }
        return respResult;
    }

    private static String encodeParameters(NameValuePair[] nameValues) {
        if (nameValues == null || nameValues.length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < nameValues.length; ++i) {
            NameValuePair nameValue = nameValues[i];
            if (i == 0) {
                buffer.append(nameValue.getName() + "=" + nameValue.getValue());
                continue;
            }
            buffer.append("&" + nameValue.getName() + "=" + nameValue.getValue());
        }
        return buffer.toString();
    }

    public static HttpClient createHttpClientInstance() {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        RequestConfig.Builder reqConfigBuilder = RequestConfig.custom();
        reqConfigBuilder.setSocketTimeout(120000);
        reqConfigBuilder.setConnectTimeout(120000);
        reqConfigBuilder.setConnectionRequestTimeout(120000);
        RequestConfig reqConfig = reqConfigBuilder.build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(SSLContexts.createDefault(), SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
        httpClientBuilder.setDefaultRequestConfig(reqConfig);
        return httpClientBuilder.build();
    }
}

