/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.utils.text;

import com.rocoinfo.utils.base.annotation.Nullable;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class TextValidator {
    private static final String REGEX_MOBILE_SIMPLE = "^[1]\\d{10}$";
    private static final Pattern PATTERN_REGEX_MOBILE_SIMPLE = Pattern.compile("^[1]\\d{10}$");
    public static final String REGEX_MOBILE_EXACT = "^((13[0-9])|(14[5,7])|(15[0-3,5-9])|(16[6])|(17[0,1,3,5-8])|(18[0-9])|(19[8,9]))\\d{8}$";
    private static final Pattern PATTERN_REGEX_MOBILE_EXACT = Pattern.compile("^((13[0-9])|(14[5,7])|(15[0-3,5-9])|(16[6])|(17[0,1,3,5-8])|(18[0-9])|(19[8,9]))\\d{8}$");
    private static final String REGEX_TEL = "^(\\d{3,4}-)?\\d{6,8}$";
    private static final Pattern PATTERN_REGEX_TEL = Pattern.compile("^(\\d{3,4}-)?\\d{6,8}$");
    private static final String REGEX_ID_CARD15 = "^[1-9]\\d{7}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}$";
    private static final Pattern PATTERN_REGEX_ID_CARD15 = Pattern.compile("^[1-9]\\d{7}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}$");
    private static final String REGEX_ID_CARD18 = "^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}([0-9Xx])$";
    private static final Pattern PATTERN_REGEX_ID_CARD18 = Pattern.compile("^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}([0-9Xx])$");
    private static final String REGEX_EMAIL = "^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$";
    private static final Pattern PATTERN_REGEX_EMAIL = Pattern.compile("^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$");
    private static final String REGEX_URL = "[a-zA-z]+://[^\\s]*";
    private static final Pattern PATTERN_REGEX_URL = Pattern.compile("[a-zA-z]+://[^\\s]*");
    private static final String REGEX_DATE = "^(?:(?!0000)[0-9]{4}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)-02-29)$";
    private static final Pattern PATTERN_REGEX_DATE = Pattern.compile("^(?:(?!0000)[0-9]{4}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)-02-29)$");
    private static final String REGEX_IP = "((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)";
    private static final Pattern PATTERN_REGEX_IP = Pattern.compile("((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\.){3}(2[0-4]\\d|25[0-5]|[01]?\\d\\d?)");
    private static final Pattern PATTERN_REGEX_POST_CODE = Pattern.compile("\\d{6}(?!\\d)");

    public static boolean isMobileSimple(@Nullable CharSequence input) {
        return TextValidator.isMatch(PATTERN_REGEX_MOBILE_SIMPLE, input);
    }

    public static boolean isMobileExact(@Nullable CharSequence input) {
        return TextValidator.isMatch(PATTERN_REGEX_MOBILE_EXACT, input);
    }

    public static boolean isTel(@Nullable CharSequence input) {
        return TextValidator.isMatch(PATTERN_REGEX_TEL, input);
    }

    public static boolean isIdCard(@Nullable CharSequence input) {
        return TextValidator.isMatch(PATTERN_REGEX_ID_CARD15, input) || TextValidator.isMatch(PATTERN_REGEX_ID_CARD18, input);
    }

    public static boolean isEmail(@Nullable CharSequence input) {
        return TextValidator.isMatch(PATTERN_REGEX_EMAIL, input);
    }

    public static boolean isUrl(@Nullable CharSequence input) {
        return TextValidator.isMatch(PATTERN_REGEX_URL, input);
    }

    public static boolean isDate(@Nullable CharSequence input) {
        return TextValidator.isMatch(PATTERN_REGEX_DATE, input);
    }

    public static boolean isPostCode(String str) {
        return TextValidator.isMatch(PATTERN_REGEX_POST_CODE, str);
    }

    public static boolean isIp(@Nullable CharSequence input) {
        return TextValidator.isMatch(PATTERN_REGEX_IP, input);
    }

    public static boolean isMatch(Pattern pattern, CharSequence input) {
        return StringUtils.isNotEmpty((CharSequence)input) && pattern.matcher(input).matches();
    }
}

