/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.utils;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public final class CookieUtil {
    public static final String SSO_TOKEN_COOKIE_NAME = "JJCToken16";

    public static void addCookie(HttpServletResponse response, String name, String value, Integer maxAge, String path, String domain) {
        if (maxAge == null) {
            maxAge = 0;
        }
        if (value == null) {
            value = "";
        }
        if (path == null) {
            path = "/";
        }
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(maxAge.intValue());
        cookie.setPath(path);
        if (StringUtils.isNotEmpty((CharSequence)domain)) {
            cookie.setDomain(domain);
        }
        response.addCookie(cookie);
    }

    public static void removeCookie(HttpServletResponse response, String cookieName, String cookiePath, String domain) {
        CookieUtil.addCookie(response, cookieName, "", 0, cookiePath, domain);
    }

    public static void addLoginCookie(HttpServletResponse response, String value, int maxAge, String domain) {
        CookieUtil.addCookie(response, SSO_TOKEN_COOKIE_NAME, value, maxAge, null, domain);
    }

    public static void removeLoginCookie(HttpServletResponse response, String domain) {
        CookieUtil.removeCookie(response, SSO_TOKEN_COOKIE_NAME, null, domain);
    }

    public static String getLoginCookieValue(HttpServletRequest request) {
        Cookie cookie = CookieUtil.getCookie(request, SSO_TOKEN_COOKIE_NAME);
        if (cookie != null) {
            return cookie.getValue();
        }
        return "";
    }

    public static Cookie getCookie(HttpServletRequest request, String cookieName) {
        return CookieUtil.readCookieMap(request).get(cookieName);
    }

    public static Map<String, Cookie> readCookieMap(HttpServletRequest request) {
        LinkedHashMap cookieMap = Maps.newLinkedHashMap();
        Cookie[] cookies = request.getCookies();
        if (null != cookies) {
            for (int i = 0; i < cookies.length; ++i) {
                cookieMap.put(cookies[i].getName(), cookies[i]);
            }
        }
        return cookieMap;
    }
}

