/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IdUtil {
    private static final Logger logger = LoggerFactory.getLogger(IdUtil.class);
    private static final Pattern PATTERN_LONG_ID = Pattern.compile("^([0-9]{15})([0-9a-f]{32})([0-9a-f]{3})$");
    private static final Pattern PATTERN_HOSTNAME = Pattern.compile("^.*\\D+([0-9]+)$");
    private static final long OFFSET = LocalDate.of(2000, 1, 1).atStartOfDay(ZoneId.of("Z")).toEpochSecond();
    private static final long MAX_NEXT = 65535L;
    private static final long SHARD_ID = IdUtil.getServerIdAsLong();
    private static long offset = 0L;
    private static long lastEpoch = 0L;

    public static long nextId() {
        return IdUtil.nextId(System.currentTimeMillis() / 1000L);
    }

    private static synchronized long nextId(long epochSecond) {
        long next;
        if (epochSecond < lastEpoch) {
            logger.warn("clock is back: " + epochSecond + " from previous:" + lastEpoch);
            epochSecond = lastEpoch;
        }
        if (lastEpoch != epochSecond) {
            lastEpoch = epochSecond;
            IdUtil.reset();
        }
        if ((next = ++offset & 0xFFFFL) == 0L) {
            logger.warn("maximum id reached in 1 second in epoch: " + epochSecond);
            return IdUtil.nextId(epochSecond + 1L);
        }
        return IdUtil.generateId(epochSecond, next, SHARD_ID);
    }

    private static void reset() {
        offset = 0L;
    }

    private static long generateId(long epochSecond, long next, long shardId) {
        return epochSecond - OFFSET << 21 | next << 5 | shardId;
    }

    private static long getServerIdAsLong() {
        try {
            long n;
            String hostname = InetAddress.getLocalHost().getHostName();
            Matcher matcher = PATTERN_HOSTNAME.matcher(hostname);
            if (matcher.matches() && (n = Long.parseLong(matcher.group(1))) >= 0L && n < 8L) {
                logger.info("detect server id from host name {}: {}.", (Object)hostname, (Object)n);
                return n;
            }
        }
        catch (UnknownHostException e) {
            logger.warn("unable to get host name. set server id = 0.");
        }
        return 0L;
    }

    public static long stringIdToLongId(String stringId) {
        Matcher matcher = PATTERN_LONG_ID.matcher(stringId);
        if (matcher.matches()) {
            long epoch = Long.parseLong(matcher.group(1)) / 1000L;
            String uuid = matcher.group(2);
            byte[] sha1 = IdUtil.sha1AsBytes(uuid);
            long next = (long)(sha1[0] << 24 | sha1[1] << 16 | sha1[2] << 8 | sha1[3]) & 0xFFFFL;
            long serverId = Long.parseLong(matcher.group(3), 16);
            return IdUtil.generateId(epoch, next, serverId);
        }
        throw new IllegalArgumentException("Invalid id: " + stringId);
    }

    public static byte[] sha1AsBytes(String str) {
        byte[] input = str.getBytes(StandardCharsets.UTF_8);
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        md.update(input);
        return md.digest();
    }
}

