/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.utils;

import org.apache.commons.lang3.StringUtils;

public final class Underline2Camel {
    private static final char SEPARATOR = '_';

    public static String underline2Camel(String underlineStr) {
        if (underlineStr == null) {
            return null;
        }
        underlineStr = underlineStr.toLowerCase();
        StringBuilder sb = new StringBuilder(underlineStr.length());
        boolean upperCase = false;
        for (int i = 0; i < underlineStr.length(); ++i) {
            char c = underlineStr.charAt(i);
            if (c == '_') {
                upperCase = true;
                continue;
            }
            if (upperCase) {
                sb.append(Character.toUpperCase(c));
                upperCase = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String camel2UnderlineLowerCase(String camelStr) {
        if (camelStr == null) {
            return null;
        }
        String dot = ".";
        boolean containPrefix = camelStr.contains(dot);
        String prefix = "";
        if (containPrefix) {
            prefix = StringUtils.substringBefore((String)camelStr, (String)dot) + dot;
            camelStr = StringUtils.substringAfter((String)camelStr, (String)dot);
        }
        StringBuilder sb = new StringBuilder(prefix);
        boolean upperCase = false;
        for (int i = 0; i < camelStr.length(); ++i) {
            char c = camelStr.charAt(i);
            boolean nextUpperCase = true;
            if (i < camelStr.length() - 1) {
                nextUpperCase = Character.isUpperCase(camelStr.charAt(i + 1));
            }
            if (i >= 0 && Character.isUpperCase(c)) {
                if (!(upperCase && nextUpperCase || i <= 0)) {
                    sb.append('_');
                }
                upperCase = true;
            } else {
                upperCase = false;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String toCapitalizeCamelCase(String underlineStr) {
        if (underlineStr == null) {
            return null;
        }
        String camelStr = Underline2Camel.underline2Camel(underlineStr);
        return camelStr.substring(0, 1).toUpperCase() + camelStr.substring(1);
    }
}

