/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UnitConverter {
    public static final int K = 1024;
    public static final long M = 0x100000L;
    public static final long G = 0x40000000L;
    public static final long T = 0x10000000000L;
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    private static final Pattern NUMBER_AND_UNIT = Pattern.compile("(\\d+)([a-zA-Z]+)?");

    public static long toDurationMillis(String duration) {
        Matcher matcher = NUMBER_AND_UNIT.matcher(duration);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("malformed duration string: " + duration);
        }
        long number = Long.parseLong(matcher.group(1));
        String unitStr = matcher.group(2);
        if (unitStr == null) {
            return number;
        }
        char unit = unitStr.toLowerCase().charAt(0);
        switch (unit) {
            case 's': {
                return number * 1000L;
            }
            case 'm': {
                if (unitStr.length() >= 2 && unitStr.charAt(1) == 's') {
                    return number;
                }
                return number * 60000L;
            }
            case 'h': {
                return number * 3600000L;
            }
            case 'd': {
                return number * 86400000L;
            }
        }
        throw new IllegalArgumentException("unknown time unit :" + unit);
    }

    public static long toBytes(String size) {
        Matcher matcher = NUMBER_AND_UNIT.matcher(size);
        if (matcher.matches()) {
            long number = Long.parseLong(matcher.group(1));
            String unitStr = matcher.group(2);
            if (unitStr != null) {
                char unit = unitStr.toLowerCase().charAt(0);
                switch (unit) {
                    case 'b': {
                        return number;
                    }
                    case 'k': {
                        return number * 1024L;
                    }
                    case 'm': {
                        return number * 0x100000L;
                    }
                    case 'g': {
                        return number * 0x40000000L;
                    }
                    case 't': {
                        return number * 0x10000000000L;
                    }
                }
                throw new IllegalArgumentException("unknown size unit :" + unit);
            }
            return number;
        }
        throw new IllegalArgumentException("malformed size string: " + size);
    }

    public static String toSizeUnit(Long bytes, int scale) {
        if (bytes == null) {
            return "n/a";
        }
        if (bytes < 1024L) {
            return String.format("%4d", bytes);
        }
        if (bytes < 0x100000L) {
            return String.format("%" + (scale == 0 ? 4 : 5 + scale) + '.' + scale + "fk", (double)bytes.longValue() * 1.0 / 1024.0);
        }
        if (bytes < 0x40000000L) {
            return String.format("%" + (scale == 0 ? 4 : 5 + scale) + '.' + scale + "fm", (double)bytes.longValue() * 1.0 / 1048576.0);
        }
        if (bytes < 0x10000000000L) {
            return String.format("%" + (scale == 0 ? 4 : 5 + scale) + '.' + scale + "fg", (double)bytes.longValue() * 1.0 / 1.073741824E9);
        }
        return String.format("%" + (scale == 0 ? 4 : 5 + scale) + '.' + scale + "ft", (double)bytes.longValue() * 1.0 / 1.099511627776E12);
    }

    public static String toTimeUnit(long millis, int scale) {
        if (millis < 1000L) {
            return String.format("%4dms", millis);
        }
        if (millis < 60000L) {
            return String.format("%" + (scale == 0 ? 2 : 3 + scale) + '.' + scale + "fs", (double)millis * 1.0 / 1000.0);
        }
        if (millis < 3600000L) {
            return String.format("%" + (scale == 0 ? 2 : 3 + scale) + '.' + scale + "fm", (double)millis * 1.0 / 60000.0);
        }
        if (millis < 86400000L) {
            return String.format("%" + (scale == 0 ? 2 : 3 + scale) + '.' + scale + "fh", (double)millis * 1.0 / 3600000.0);
        }
        return String.format("%" + (scale == 0 ? 2 : 3 + scale) + '.' + scale + "fd", (double)millis * 1.0 / 8.64E7);
    }

    public static String toTimeWithMinorUnit(long millis) {
        if (millis < 1000L) {
            return String.format("%4dms", millis);
        }
        if (millis < 60000L) {
            return String.format("%02ds", millis / 1000L);
        }
        if (millis < 3600000L) {
            return String.format("%02dm%02ds", millis / 60000L, millis / 1000L % 60L);
        }
        if (millis < 86400000L) {
            return String.format("%02dh%02dm", millis / 3600000L, millis / 60000L % 60L);
        }
        return String.format("%dd%02dh", millis / 86400000L, millis / 3600000L % 24L);
    }
}

