/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.utils.collection;

import com.google.common.annotations.Beta;
import com.rocoinfo.utils.reflect.ReflectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@Beta
public class CollectionExtractor {
    public static Map extractToMap(Collection collection, String keyPropertyName, String valuePropertyName) {
        HashMap map = new HashMap(collection.size());
        try {
            for (Object obj : collection) {
                map.put(ReflectionUtil.getFieldValue(obj, keyPropertyName), ReflectionUtil.getFieldValue(obj, valuePropertyName));
            }
        }
        catch (Exception e) {
            throw ReflectionUtil.convertReflectionExceptionToUnchecked(e);
        }
        return map;
    }

    public static List extractToList(Collection collection, String propertyName) {
        ArrayList list = new ArrayList(collection.size());
        try {
            for (Object obj : collection) {
                list.add(ReflectionUtil.getFieldValue(obj, propertyName));
            }
        }
        catch (Exception e) {
            throw ReflectionUtil.convertReflectionExceptionToUnchecked(e);
        }
        return list;
    }

    public static String extractToString(Collection collection, String propertyName, String separator) {
        List list = CollectionExtractor.extractToList(collection, propertyName);
        return StringUtils.join((Iterable)list, (String)separator);
    }

    public static String convertToString(Collection collection, String separator) {
        return StringUtils.join((Iterable)collection, (String)separator);
    }

    public static String convertToString(Collection collection, String prefix, String postfix) {
        StringBuilder builder = new StringBuilder();
        for (Object o : collection) {
            builder.append(prefix).append(o).append(postfix);
        }
        return builder.toString();
    }
}

