/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.utils.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public final class ListUtil {
    public static <T> T getFirst(List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    public static <T> T getLast(List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public static void shuffle(List<?> list) {
        Collections.shuffle(list);
    }

    public static <T> void sort(List<T> list, Comparator<? super T> c) {
        Collections.sort(list, c);
    }

    public static <T> void sortReverse(List<T> list, Comparator<? super T> c) {
        Collections.sort(list, Collections.reverseOrder(c));
    }

    public static <E> List<E> union(List<? extends E> list1, List<? extends E> list2) {
        ArrayList<E> result = new ArrayList<E>(list1.size() + list2.size());
        result.addAll(list1);
        result.addAll(list2);
        return result;
    }

    public static <T> List<T> intersection(List<? extends T> list1, List<? extends T> list2) {
        List<T> smaller = list1;
        List<Object> larger = list2;
        if (list1.size() > list2.size()) {
            smaller = list2;
            larger = list1;
        }
        ArrayList<T> newSmaller = new ArrayList<T>(smaller);
        ArrayList<Object> result = new ArrayList<Object>(smaller.size());
        for (Object e : larger) {
            if (!newSmaller.contains(e)) continue;
            result.add(e);
            newSmaller.remove(e);
        }
        return result;
    }

    public static <T> List<T> difference(List<? extends T> list1, List<? extends T> list2) {
        ArrayList<T> result = new ArrayList<T>(list1);
        Iterator<T> iterator = list2.iterator();
        while (iterator.hasNext()) {
            result.remove(iterator.next());
        }
        return result;
    }

    public static <T> List<T> disjoint(List<? extends T> list1, List<? extends T> list2) {
        List<? extends T> intersection = ListUtil.intersection(list1, list2);
        List<? extends T> towIntersection = ListUtil.union(intersection, intersection);
        return ListUtil.difference(ListUtil.union(list1, list2), towIntersection);
    }
}

