/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.utils.excel;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public final class ExcelTemplate {
    public static final String DATA_LINE = "datas";
    public static final String DEFAULT_STYLE = "defaultStyles";
    public static final String STYLE = "styles";
    public static final String SER_NUM = "sernums";
    private Workbook wb;
    private Sheet sheet;
    private int dataInitColIndex;
    private int dataInitRowIndex;
    private int curColIndex;
    private int curRowIndex;
    private Row curRow;
    private int lastRowIndex;
    private CellStyle defaultStyle;
    private float defaultRowHeight;
    private Map<Integer, CellStyle> colStyleMap;
    private int serColIndex;

    public ExcelTemplate readTemplateByClasspath(String clsPath) {
        try {
            this.wb = WorkbookFactory.create((InputStream)this.getClass().getClassLoader().getResourceAsStream(clsPath));
            this.initTemplate();
        }
        catch (InvalidFormatException e) {
            e.printStackTrace();
            throw new RuntimeException("\u8bfb\u53d6\u6a21\u677f\u683c\u5f0f\u6709\u9519\uff0c\uff01\u8bf7\u68c0\u67e5");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("\u8bfb\u53d6\u6a21\u677f\u4e0d\u5b58\u5728\uff01\u8bf7\u68c0\u67e5");
        }
        return this;
    }

    public void writeToFile(String filepath) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filepath);
            this.wb.write((OutputStream)fos);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException("\u5199\u5165\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("\u5199\u5165\u6570\u636e\u5931\u8d25:" + e.getMessage());
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void wirteToStream(OutputStream os) {
        try {
            this.wb.write(os);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("\u5199\u5165\u6d41\u5931\u8d25:" + e.getMessage());
        }
    }

    public ExcelTemplate readTemplateByPath(String fileAbsolutePath) {
        try {
            File file = new File(fileAbsolutePath);
            this.wb = WorkbookFactory.create((File)file);
            this.initTemplate();
        }
        catch (InvalidFormatException e) {
            e.printStackTrace();
            throw new RuntimeException("\u8bfb\u53d6\u6a21\u677f\u683c\u5f0f\u6709\u9519\uff0c\uff01\u8bf7\u68c0\u67e5");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("\u8bfb\u53d6\u6a21\u677f\u4e0d\u5b58\u5728\uff01\u8bf7\u68c0\u67e5");
        }
        return this;
    }

    public void createCell(String value) {
        Cell c = this.curRow.createCell(this.curColIndex);
        this.setCellStyle(c);
        c.setCellType(1);
        c.setCellValue(value);
        ++this.curColIndex;
    }

    public void createCell(int value) {
        Cell c = this.curRow.createCell(this.curColIndex);
        this.setCellStyle(c);
        c.setCellType(0);
        c.setCellValue((double)value);
        ++this.curColIndex;
    }

    public void createCell(Date value) {
        Cell c = this.curRow.createCell(this.curColIndex);
        this.setCellStyle(c);
        c.setCellValue(value);
        ++this.curColIndex;
    }

    public void createCell(double value) {
        Cell c = this.curRow.createCell(this.curColIndex);
        this.setCellStyle(c);
        c.setCellType(0);
        c.setCellValue(value);
        ++this.curColIndex;
    }

    public void createCell(boolean value) {
        Cell c = this.curRow.createCell(this.curColIndex);
        this.setCellStyle(c);
        c.setCellType(4);
        c.setCellValue(value);
        ++this.curColIndex;
    }

    public void createCell(Calendar value) {
        Cell c = this.curRow.createCell(this.curColIndex);
        this.setCellStyle(c);
        c.setCellValue(value);
        ++this.curColIndex;
    }

    private void setCellStyle(Cell c) {
        if (this.colStyleMap.containsKey(this.curColIndex)) {
            c.setCellStyle(this.colStyleMap.get(this.curColIndex));
        } else {
            c.setCellStyle(this.defaultStyle);
        }
    }

    public void createNewRow() {
        if (this.lastRowIndex > this.curRowIndex && this.curRowIndex != this.dataInitRowIndex) {
            this.sheet.shiftRows(this.curRowIndex, this.lastRowIndex, 1, true, true);
            ++this.lastRowIndex;
        }
        this.curRow = this.sheet.createRow(this.curRowIndex);
        this.curRow.setHeightInPoints(this.defaultRowHeight);
        ++this.curRowIndex;
        this.curColIndex = this.dataInitColIndex;
    }

    public void insertSerFinally() {
        int seq = 1;
        Row row = null;
        Cell c = null;
        for (int i = this.dataInitRowIndex; i < this.curRowIndex; ++i) {
            row = this.sheet.getRow(i);
            c = row.createCell(this.serColIndex);
            this.setCellStyle(c);
            c.setCellValue((double)seq++);
        }
    }

    public void replaceFinalData(Map<String, String> datas) {
        if (datas != null) {
            Properties props = new Properties();
            props.putAll(datas);
            this.replaceFinalData(props);
        }
    }

    public void replaceFinalData(Properties prop) {
        if (prop != null) {
            for (Row row : this.sheet) {
                for (Cell c : row) {
                    String replacekey;
                    if (c.getCellType() != 1) continue;
                    String spliter = "#";
                    String str = c.getStringCellValue().trim();
                    if (!str.contains(spliter) || !prop.containsKey(replacekey = StringUtils.substringBetween((String)str, (String)spliter, (String)spliter))) continue;
                    String celValue = StringUtils.replace((String)str, (String)StringUtils.wrap((String)replacekey, (String)spliter), (String)prop.getProperty(replacekey));
                    c.setCellValue(celValue);
                }
            }
        }
    }

    private void initTemplate() {
        this.sheet = this.wb.getSheetAt(0);
        this.initConfigData();
        this.lastRowIndex = this.sheet.getLastRowNum();
    }

    private void initConfigData() {
        boolean findData = false;
        boolean findSer = false;
        block0: for (Row row : this.sheet) {
            if (findData) break;
            for (Cell c : row) {
                if (c.getCellType() != 1) continue;
                String str = c.getStringCellValue().trim();
                if (str.equals(SER_NUM)) {
                    this.serColIndex = c.getColumnIndex();
                    findSer = true;
                    continue;
                }
                if (!str.equals(DATA_LINE)) continue;
                this.dataInitColIndex = c.getColumnIndex();
                this.dataInitRowIndex = row.getRowNum();
                this.curColIndex = this.dataInitColIndex;
                this.curRowIndex = this.dataInitRowIndex;
                this.defaultStyle = c.getCellStyle();
                this.defaultRowHeight = row.getHeightInPoints();
                findData = true;
                this.initStyles();
                continue block0;
            }
        }
        if (!findSer) {
            this.initSer();
        }
    }

    private void initSer() {
        for (Row row : this.sheet) {
            for (Cell c : row) {
                String str;
                if (c.getCellType() != 1 || !(str = c.getStringCellValue().trim()).equals(SER_NUM)) continue;
                this.serColIndex = c.getColumnIndex();
            }
        }
    }

    private void initStyles() {
        this.colStyleMap = new HashMap<Integer, CellStyle>();
        for (Row row : this.sheet) {
            for (Cell c : row) {
                if (c.getCellType() != 1) continue;
                String str = c.getStringCellValue().trim();
                if (str.equals(DEFAULT_STYLE)) {
                    this.defaultStyle = c.getCellStyle();
                    continue;
                }
                if (!str.equals(STYLE)) continue;
                this.colStyleMap.put(c.getColumnIndex(), c.getCellStyle());
            }
        }
    }
}

