/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.utils.img;

import com.rocoinfo.utils.io.FileUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.geometry.Position;
import net.coobird.thumbnailator.geometry.Positions;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public final class ImageUtil {
    private static final String[] IMAGES_SUFFIXES = new String[]{"bmp", "jpg", "jpeg", "gif", "png", "tiff"};

    public static boolean isImage(String filename) {
        if (StringUtils.isBlank((CharSequence)filename)) {
            return false;
        }
        return ArrayUtils.contains((Object[])IMAGES_SUFFIXES, (Object)FilenameUtils.getExtension((String)filename).toLowerCase());
    }

    public static int[] getSizeInfo(String filePath) throws Exception {
        File file = new File(filePath);
        return ImageUtil.getSizeInfo(file);
    }

    public static int[] getSizeInfo(URL url) throws Exception {
        int[] nArray;
        InputStream input = null;
        try {
            input = url.openStream();
            nArray = ImageUtil.getSizeInfo(input);
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
                throw new Exception(e);
            }
            catch (Throwable throwable) {
                FileUtil.closeIO(input);
                throw throwable;
            }
        }
        FileUtil.closeIO(input);
        return nArray;
    }

    public static int[] getSizeInfo(File file) throws Exception {
        int[] nArray;
        if (!file.exists()) {
            throw new Exception("file " + file.getAbsolutePath() + " doesn't exist.");
        }
        BufferedInputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(file));
            nArray = ImageUtil.getSizeInfo(input);
        }
        catch (FileNotFoundException e) {
            try {
                e.printStackTrace();
                throw new Exception(e);
            }
            catch (Throwable throwable) {
                FileUtil.closeIO(input);
                throw throwable;
            }
        }
        FileUtil.closeIO(input);
        return nArray;
    }

    public static int[] getSizeInfo(InputStream input) throws Exception {
        try {
            BufferedImage img = ImageIO.read(input);
            int w = img.getWidth(null);
            int h = img.getHeight(null);
            return new int[]{w, h};
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Exception(e);
        }
    }

    public static void resize(String srcFilePath, String destFile, int resizeToWidth, int resizeToHeight) throws Exception {
        ImageUtil.resize(srcFilePath, destFile, resizeToWidth, resizeToHeight, -1, -1);
    }

    public static ByteArrayOutputStream resize(byte[] data, Positions positions, int width, int height, String formatName) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            BufferedImage bufferedImage = Thumbnails.of((InputStream[])new InputStream[]{new ByteArrayInputStream(data)}).sourceRegion((Position)positions, width, height).outputQuality(0.8f).size(width, height).asBufferedImage();
            ImageIO.write((RenderedImage)bufferedImage, formatName, byteArrayOutputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return byteArrayOutputStream;
    }

    public static void resize(InputStream input, OutputStream output, int width, int height) throws Exception {
        ImageUtil.resize(input, output, width, height, -1, -1);
    }

    public static byte[] resize(byte[] data, String formatName, int resizeToWidth, int resizeToHeight) throws IOException {
        BufferedImage bufImg = Thumbnails.of((InputStream[])new InputStream[]{new ByteArrayInputStream(data)}).outputQuality(0.8f).size(resizeToWidth, resizeToHeight).asBufferedImage();
        return ImageUtil.paddingWhite(bufImg, formatName, resizeToWidth, resizeToHeight).toByteArray();
    }

    public static byte[] resize(byte[] data, String formatName, double scale) throws IOException {
        BufferedImage src = Thumbnails.of((InputStream[])new InputStream[]{new ByteArrayInputStream(data)}).outputQuality(0.8f).scale(scale).asBufferedImage();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)src, formatName, out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out.toByteArray();
    }

    public static void paddingWhite(BufferedImage src, OutputStream out, String formatName, int targetWidth, int targetHeight) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (width == targetWidth && height == targetHeight) {
            try {
                ImageIO.write((RenderedImage)src, formatName, out);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        BufferedImage bufImg = new BufferedImage(targetWidth, targetHeight, 1);
        Graphics2D graphics = bufImg.createGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, targetWidth, targetHeight);
        int x = 0;
        int y = 0;
        if (targetWidth > width) {
            x = (targetWidth - width) / 2;
        }
        if (targetHeight > height) {
            y = (targetHeight - height) / 2;
        }
        graphics.drawImage(src, null, x, y);
        graphics.dispose();
        try {
            ImageIO.write((RenderedImage)bufImg, formatName, out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ByteArrayOutputStream paddingWhite(BufferedImage src, String formatName, int targetWidth, int targetHeight) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageUtil.paddingWhite(src, out, formatName, targetWidth, targetHeight);
        return out;
    }

    public static void resize(InputStream input, OutputStream output, int width, int height, int maxWidth, int maxHeight) throws Exception {
        if (width < 1 && height < 1 && maxWidth < 1 && maxHeight < 1) {
            try {
                IOUtils.copy((InputStream)input, (OutputStream)output);
            }
            catch (IOException e) {
                throw new Exception("resize error: ", e);
            }
        }
        try {
            int toHeight;
            int toWidth;
            BufferedImage img = ImageIO.read(input);
            boolean hasNotAlpha = !img.getColorModel().hasAlpha();
            double w = img.getWidth(null);
            double h = img.getHeight(null);
            double rate = w / h;
            if (width > 0 && height > 0) {
                rate = (double)width / (double)height;
                toWidth = width;
                toHeight = height;
            } else if (width > 0) {
                toWidth = width;
                toHeight = (int)((double)toWidth / rate);
            } else if (height > 0) {
                toHeight = height;
                toWidth = (int)((double)toHeight * rate);
            } else {
                toWidth = ((Number)w).intValue();
                toHeight = ((Number)h).intValue();
            }
            if (maxWidth > 0 && toWidth > maxWidth) {
                toWidth = maxWidth;
                toHeight = (int)((double)toWidth / rate);
            }
            if (maxHeight > 0 && toHeight > maxHeight) {
                toHeight = maxHeight;
                toWidth = (int)((double)toHeight * rate);
            }
            BufferedImage tag = new BufferedImage(toWidth, toHeight, hasNotAlpha ? 1 : 2);
            tag.getGraphics().drawImage(img.getScaledInstance(toWidth, toHeight, 4), 0, 0, null);
            ImageIO.write((RenderedImage)tag, hasNotAlpha ? "jpg" : "png", output);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new Exception(e);
            }
            catch (Throwable throwable) {
                FileUtil.closeIO(input, output);
                throw throwable;
            }
        }
        FileUtil.closeIO(input, output);
    }

    public static void resize(String srcFile, String destFile, int width, int height, int maxWidth, int maxHeight) throws Exception {
        ImageUtil.resize(new File(srcFile), new File(destFile), width, height, maxWidth, maxHeight);
    }

    public static void resize(File srcFile, File destFile, int width, int height) throws Exception {
        ImageUtil.resize(srcFile, destFile, width, height, -1, -1);
    }

    public static void resize(File srcFile, File destFile, int width, int height, int maxWidth, int maxHeight) throws Exception {
        if (destFile.exists()) {
            destFile.delete();
        } else {
            FileUtil.makesureDirExists(destFile.getParent());
        }
        BufferedInputStream input = null;
        FileOutputStream output = null;
        try {
            input = new BufferedInputStream(new FileInputStream(srcFile));
            output = new FileOutputStream(destFile);
            ImageUtil.resize(input, output, width, height, maxWidth, maxHeight);
        }
        catch (FileNotFoundException e) {
            try {
                e.printStackTrace();
                throw new Exception(e);
            }
            catch (Throwable throwable) {
                FileUtil.closeIO(input, output);
                throw throwable;
            }
        }
        FileUtil.closeIO(input, output);
    }

    public static void crop(String source, String target, int x, int y, int w, int h) throws Exception {
        ImageUtil.crop(new File(source), new File(target), x, y, w, h);
    }

    public static void crop(File source, File target, int x, int y, int w, int h) throws Exception {
        BufferedOutputStream output = null;
        BufferedInputStream input = null;
        String ext = FilenameUtils.getExtension((String)target.getName());
        try {
            input = new BufferedInputStream(new FileInputStream(source));
            if (target.exists()) {
                target.delete();
            } else {
                FileUtil.makesureDirExists(target.getParent());
            }
            output = new BufferedOutputStream(new FileOutputStream(target));
        }
        catch (IOException e) {
            throw new Exception(e);
        }
        ImageUtil.crop(input, output, x, y, w, h, StringUtils.equalsIgnoreCase((CharSequence)"png", (CharSequence)ext));
    }

    public static void crop(InputStream input, OutputStream output, int x, int y, int w, int h, boolean isPNG) throws Exception {
        try {
            BufferedImage srcImg = ImageIO.read(input);
            int tmpWidth = srcImg.getWidth();
            int tmpHeight = srcImg.getHeight();
            int xx = Math.min(tmpWidth - 1, x);
            int yy = Math.min(tmpHeight - 1, y);
            int ww = w;
            if (xx + w > tmpWidth) {
                ww = Math.max(1, tmpWidth - xx);
            }
            int hh = h;
            if (yy + h > tmpHeight) {
                hh = Math.max(1, tmpHeight - yy);
            }
            BufferedImage dest = srcImg.getSubimage(xx, yy, ww, hh);
            BufferedImage tag = new BufferedImage(w, h, isPNG ? 2 : 1);
            tag.getGraphics().drawImage(dest, 0, 0, null);
            ImageIO.write((RenderedImage)tag, isPNG ? "png" : "jpg", output);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new Exception(e);
            }
            catch (Throwable throwable) {
                FileUtil.closeIO(input, output);
                throw throwable;
            }
        }
        FileUtil.closeIO(input, output);
    }

    public static final void optimize(InputStream input, OutputStream output, float quality) throws Exception {
        ImageInputStream ios = null;
        ImageWriter writer = null;
        try {
            BufferedImage image = ImageIO.read(input);
            Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("jpeg");
            if (!writers.hasNext()) {
                throw new IllegalStateException("No writers found");
            }
            writer = writers.next();
            ios = ImageIO.createImageOutputStream(output);
            writer.setOutput(ios);
            ImageWriteParam param = writer.getDefaultWriteParam();
            param.setCompressionMode(2);
            param.setCompressionQuality(quality);
            writer.write(null, new IIOImage(image, null, null), param);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        finally {
            if (ios != null) {
                try {
                    ios.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new Exception(e);
                }
            }
            writer.dispose();
        }
    }

    public static final void optimize(String source, String target, float quality) throws Exception {
        File fromFile = new File(source);
        File toFile = new File(target);
        ImageUtil.optimize(fromFile, toFile, quality);
    }

    public static final void optimize(File source, File target, float quality) throws Exception {
        if (target.exists()) {
            target.delete();
        } else {
            FileUtil.makesureDirExists(target.getParent());
        }
        BufferedInputStream is = null;
        BufferedOutputStream os = null;
        try {
            is = new BufferedInputStream(new FileInputStream(source));
            os = new BufferedOutputStream(new FileOutputStream(target));
            ImageUtil.optimize(is, os, quality);
        }
        catch (FileNotFoundException e) {
            try {
                throw new Exception(e);
            }
            catch (Throwable throwable) {
                FileUtil.closeIO(is, os);
                throw throwable;
            }
        }
        FileUtil.closeIO(is, os);
    }

    public static void makeRoundedCorner(File srcFile, File destFile, int cornerRadius) throws Exception {
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            in = new BufferedInputStream(new FileInputStream(srcFile));
            FileUtil.makesureDirExists(destFile.getParentFile().getAbsolutePath());
            out = new BufferedOutputStream(new FileOutputStream(destFile));
            ImageUtil.makeRoundedCorner(in, out, cornerRadius);
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
                throw new Exception(e);
            }
            catch (Throwable throwable) {
                FileUtil.closeIO(out, in);
                throw throwable;
            }
        }
        FileUtil.closeIO(out, in);
    }

    public static void makeRoundedCorner(String srcFile, String destFile, int cornerRadius) throws Exception {
        ImageUtil.makeRoundedCorner(new File(srcFile), new File(destFile), cornerRadius);
    }

    public static void makeRoundedCorner(InputStream inputStream, OutputStream outputStream, int radius) throws Exception {
        BufferedImage sourceImage = null;
        BufferedImage targetImage = null;
        try {
            sourceImage = ImageIO.read(inputStream);
            int w = sourceImage.getWidth();
            int h = sourceImage.getHeight();
            System.out.println(w);
            int cornerRadius = radius < 1 ? w / 4 : radius;
            targetImage = new BufferedImage(w, h, 2);
            Graphics2D g2 = targetImage.createGraphics();
            g2.setComposite(AlphaComposite.Src);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(Color.WHITE);
            g2.fill(new RoundRectangle2D.Float(0.0f, 0.0f, w, h, cornerRadius, cornerRadius));
            g2.setComposite(AlphaComposite.SrcAtop);
            g2.drawImage((Image)sourceImage, 0, 0, null);
            g2.dispose();
            ImageIO.write((RenderedImage)targetImage, "png", outputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Exception(e);
        }
    }
}

