/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.utils.io;

import com.rocoinfo.utils.text.Charsets;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class FileUtil {
    private FileUtil() {
        throw new UnsupportedOperationException("u can't fuck me...");
    }

    public static byte[] toByteArray(File file) throws IOException {
        return Files.readAllBytes(file.toPath());
    }

    public static String toString(File file) throws IOException {
        return com.google.common.io.Files.toString((File)file, (Charset)Charsets.UTF_8);
    }

    public static List<String> toLines(File file) throws IOException {
        return Files.readAllLines(file.toPath(), Charsets.UTF_8);
    }

    public static void write(CharSequence data, File file) throws IOException {
        Validate.notNull((Object)file);
        Validate.notNull((Object)data);
        try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), Charsets.UTF_8, new OpenOption[0]);){
            writer.append(data);
        }
    }

    public static void append(CharSequence data, File file) throws IOException {
        Validate.notNull((Object)file);
        Validate.notNull((Object)data);
        try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), Charsets.UTF_8, StandardOpenOption.APPEND);){
            writer.append(data);
        }
    }

    public static InputStream asInputStream(String filePath) throws IOException {
        return FileUtil.asInputStream(FileUtil.getPath(filePath));
    }

    public static InputStream asInputStream(File file) throws IOException {
        Validate.notNull((Object)file, (String)"file is null", (Object[])new Object[0]);
        return FileUtil.asInputStream(file.toPath());
    }

    public static InputStream asInputStream(Path path) throws IOException {
        Validate.notNull((Object)path, (String)"path is null", (Object[])new Object[0]);
        return Files.newInputStream(path, new OpenOption[0]);
    }

    public static OutputStream asOututStream(String filePath) throws IOException {
        return FileUtil.asOututStream(FileUtil.getPath(filePath));
    }

    public static OutputStream asOututStream(File file) throws IOException {
        Validate.notNull((Object)file, (String)"file is null", (Object[])new Object[0]);
        return FileUtil.asOututStream(file.toPath());
    }

    public static OutputStream asOututStream(Path path) throws IOException {
        Validate.notNull((Object)path, (String)"path is null", (Object[])new Object[0]);
        return Files.newOutputStream(path, new OpenOption[0]);
    }

    public static BufferedReader asBufferedReader(String fileName) throws IOException {
        Validate.notBlank((CharSequence)fileName, (String)"filename is blank", (Object[])new Object[0]);
        return FileUtil.asBufferedReader(FileUtil.getPath(fileName));
    }

    public static BufferedReader asBufferedReader(Path path) throws IOException {
        Validate.notNull((Object)path, (String)"path is null", (Object[])new Object[0]);
        return Files.newBufferedReader(path, Charsets.UTF_8);
    }

    public static BufferedWriter asBufferedWriter(String fileName) throws IOException {
        Validate.notBlank((CharSequence)fileName, (String)"filename is blank", (Object[])new Object[0]);
        return Files.newBufferedWriter(FileUtil.getPath(fileName), Charsets.UTF_8, new OpenOption[0]);
    }

    public static BufferedWriter asBufferedWriter(Path path) throws IOException {
        Validate.notNull((Object)path, (String)"path is null", (Object[])new Object[0]);
        return Files.newBufferedWriter(path, Charsets.UTF_8, new OpenOption[0]);
    }

    public static File getFileByPath(String filePath) {
        return StringUtils.isEmpty((CharSequence)filePath) ? null : new File(filePath);
    }

    public static void makesureDirExists(String dirPath) throws IOException {
        FileUtil.makesureDirExists(FileUtil.getPath(dirPath));
    }

    private static Path getPath(String filePath) {
        return Paths.get(filePath, new String[0]);
    }

    public static void makesureDirExists(File file) throws IOException {
        Validate.notNull((Object)file);
        FileUtil.makesureDirExists(file.toPath());
    }

    public static void makesureDirExists(Path dirPath) throws IOException {
        Validate.notNull((Object)dirPath);
        Files.createDirectories(dirPath, new FileAttribute[0]);
    }

    public static void makesureParentDirExists(File file) throws IOException {
        Validate.notNull((Object)file);
        FileUtil.makesureDirExists(file.getParentFile());
    }

    public static boolean isFileExists(String filePath) {
        return FileUtil.isFileExists(FileUtil.getFileByPath(filePath));
    }

    public static boolean isFileExists(File file) {
        return file != null && file.exists();
    }

    public static boolean isDir(String dirPath) {
        return FileUtil.isDir(FileUtil.getFileByPath(dirPath));
    }

    public static boolean isDir(File file) {
        return FileUtil.isFileExists(file) && file.isDirectory();
    }

    public static boolean isFile(String filePath) {
        return FileUtil.isFile(FileUtil.getFileByPath(filePath));
    }

    public static boolean isFile(File file) {
        return FileUtil.isFileExists(file) && file.isFile();
    }

    public static boolean createOrExistsDir(String dirPath) {
        return FileUtil.createOrExistsDir(FileUtil.getFileByPath(dirPath));
    }

    public static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    public static boolean createOrExistsFile(String filePath) {
        return FileUtil.createOrExistsFile(FileUtil.getFileByPath(filePath));
    }

    public static boolean createOrExistsFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return file.isFile();
        }
        if (!FileUtil.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean createFileByDeleteOldFile(String filePath) {
        return FileUtil.createFileByDeleteOldFile(FileUtil.getFileByPath(filePath));
    }

    public static boolean createFileByDeleteOldFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists() && file.isFile() && !file.delete()) {
            return false;
        }
        if (!FileUtil.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean copyOrMoveDir(String srcDirPath, String destDirPath, boolean isMove) {
        return FileUtil.copyOrMoveDir(FileUtil.getFileByPath(srcDirPath), FileUtil.getFileByPath(destDirPath), isMove);
    }

    private static boolean copyOrMoveDir(File srcDir, File destDir, boolean isMove) {
        File[] files;
        if (srcDir == null || destDir == null) {
            return false;
        }
        String srcPath = srcDir.getPath() + File.separator;
        String destPath = destDir.getPath() + File.separator;
        if (destPath.contains(srcPath)) {
            return false;
        }
        if (!srcDir.exists() || !srcDir.isDirectory()) {
            return false;
        }
        if (!FileUtil.createOrExistsDir(destDir)) {
            return false;
        }
        for (File file : files = srcDir.listFiles()) {
            File oneDestFile = new File(destPath + file.getName());
            if (!(file.isFile() ? !FileUtil.copyOrMoveFile(file, oneDestFile, isMove) : file.isDirectory() && !FileUtil.copyOrMoveDir(file, oneDestFile, isMove))) continue;
            return false;
        }
        return !isMove || FileUtil.deleteDir(srcDir);
    }

    private static boolean copyOrMoveFile(String srcFilePath, String destFilePath, boolean isMove) {
        return FileUtil.copyOrMoveFile(FileUtil.getFileByPath(srcFilePath), FileUtil.getFileByPath(destFilePath), isMove);
    }

    private static boolean copyOrMoveFile(File srcFile, File destFile, boolean isMove) {
        if (srcFile == null || destFile == null) {
            return false;
        }
        if (!srcFile.exists() || !srcFile.isFile()) {
            return false;
        }
        if (destFile.exists() && destFile.isFile()) {
            return false;
        }
        if (!FileUtil.createOrExistsDir(destFile.getParentFile())) {
            return false;
        }
        try {
            return FileUtil.writeFileFromIS(destFile, (InputStream)new FileInputStream(srcFile), false) && (!isMove || FileUtil.deleteFile(srcFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean copyDir(String srcDirPath, String destDirPath) {
        return FileUtil.copyDir(FileUtil.getFileByPath(srcDirPath), FileUtil.getFileByPath(destDirPath));
    }

    public static boolean copyDir(File srcDir, File destDir) {
        return FileUtil.copyOrMoveDir(srcDir, destDir, false);
    }

    public static boolean copyFile(String srcFilePath, String destFilePath) {
        return FileUtil.copyFile(FileUtil.getFileByPath(srcFilePath), FileUtil.getFileByPath(destFilePath));
    }

    public static boolean copyFile(File srcFile, File destFile) {
        return FileUtil.copyOrMoveFile(srcFile, destFile, false);
    }

    public static boolean moveDir(String srcDirPath, String destDirPath) {
        return FileUtil.moveDir(FileUtil.getFileByPath(srcDirPath), FileUtil.getFileByPath(destDirPath));
    }

    public static boolean moveDir(File srcDir, File destDir) {
        return FileUtil.copyOrMoveDir(srcDir, destDir, true);
    }

    public static boolean moveFile(String srcFilePath, String destFilePath) {
        return FileUtil.moveFile(FileUtil.getFileByPath(srcFilePath), FileUtil.getFileByPath(destFilePath));
    }

    public static boolean moveFile(File srcFile, File destFile) {
        return FileUtil.copyOrMoveFile(srcFile, destFile, true);
    }

    public static boolean deleteDir(String dirPath) {
        return FileUtil.deleteDir(FileUtil.getFileByPath(dirPath));
    }

    public static boolean deleteDir(File dir) {
        File[] files;
        if (dir == null) {
            return false;
        }
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        for (File file : files = dir.listFiles()) {
            if (!(file.isFile() ? !FileUtil.deleteFile(file) : file.isDirectory() && !FileUtil.deleteDir(file))) continue;
            return false;
        }
        return dir.delete();
    }

    public static boolean deleteFile(String srcFilePath) {
        return FileUtil.deleteFile(FileUtil.getFileByPath(srcFilePath));
    }

    public static boolean deleteFile(File file) {
        return file != null && (!file.exists() || file.isFile() && file.delete());
    }

    public static List<File> listFilesInDir(String dirPath, boolean isRecursive) {
        return FileUtil.listFilesInDir(FileUtil.getFileByPath(dirPath), isRecursive);
    }

    public static List<File> listFilesInDir(File dir, boolean isRecursive) {
        if (isRecursive) {
            return FileUtil.listFilesInDir(dir);
        }
        if (dir == null || !FileUtil.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        Collections.addAll(list, dir.listFiles());
        return list;
    }

    public static List<File> listFilesInDir(String dirPath) {
        return FileUtil.listFilesInDir(FileUtil.getFileByPath(dirPath));
    }

    public static List<File> listFilesInDir(File dir) {
        File[] files;
        if (dir == null || !FileUtil.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        for (File file : files = dir.listFiles()) {
            list.add(file);
            if (!file.isDirectory()) continue;
            list.addAll(FileUtil.listFilesInDir(file));
        }
        return list;
    }

    public static List<File> listFilesInDirWithFilter(String dirPath, String suffix, boolean isRecursive) {
        return FileUtil.listFilesInDirWithFilter(FileUtil.getFileByPath(dirPath), suffix, isRecursive);
    }

    public static List<File> listFilesInDirWithFilter(File dir, String suffix, boolean isRecursive) {
        File[] files;
        if (isRecursive) {
            return FileUtil.listFilesInDirWithFilter(dir, suffix);
        }
        if (dir == null || !FileUtil.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        for (File file : files = dir.listFiles()) {
            if (!file.getName().toUpperCase().endsWith(suffix.toUpperCase())) continue;
            list.add(file);
        }
        return list;
    }

    public static List<File> listFilesInDirWithFilter(String dirPath, String suffix) {
        return FileUtil.listFilesInDirWithFilter(FileUtil.getFileByPath(dirPath), suffix);
    }

    public static List<File> listFilesInDirWithFilter(File dir, String suffix) {
        File[] files;
        if (dir == null || !FileUtil.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        for (File file : files = dir.listFiles()) {
            if (file.getName().toUpperCase().endsWith(suffix.toUpperCase())) {
                list.add(file);
            }
            if (!file.isDirectory()) continue;
            list.addAll(FileUtil.listFilesInDirWithFilter(file, suffix));
        }
        return list;
    }

    public static List<File> listFilesInDirWithFilter(String dirPath, FilenameFilter filter, boolean isRecursive) {
        return FileUtil.listFilesInDirWithFilter(FileUtil.getFileByPath(dirPath), filter, isRecursive);
    }

    public static List<File> listFilesInDirWithFilter(File dir, FilenameFilter filter, boolean isRecursive) {
        File[] files;
        if (isRecursive) {
            return FileUtil.listFilesInDirWithFilter(dir, filter);
        }
        if (dir == null || !FileUtil.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        for (File file : files = dir.listFiles()) {
            if (!filter.accept(file.getParentFile(), file.getName())) continue;
            list.add(file);
        }
        return list;
    }

    public static List<File> listFilesInDirWithFilter(String dirPath, FilenameFilter filter) {
        return FileUtil.listFilesInDirWithFilter(FileUtil.getFileByPath(dirPath), filter);
    }

    public static List<File> listFilesInDirWithFilter(File dir, FilenameFilter filter) {
        File[] files;
        if (dir == null || !FileUtil.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        for (File file : files = dir.listFiles()) {
            if (filter.accept(file.getParentFile(), file.getName())) {
                list.add(file);
            }
            if (!file.isDirectory()) continue;
            list.addAll(FileUtil.listFilesInDirWithFilter(file, filter));
        }
        return list;
    }

    public static List<File> searchFileInDir(String dirPath, String fileName) {
        return FileUtil.searchFileInDir(FileUtil.getFileByPath(dirPath), fileName);
    }

    public static List<File> searchFileInDir(File dir, String fileName) {
        File[] files;
        if (dir == null || !FileUtil.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        for (File file : files = dir.listFiles()) {
            if (file.getName().toUpperCase().equals(fileName.toUpperCase())) {
                list.add(file);
            }
            if (!file.isDirectory()) continue;
            list.addAll(FileUtil.listFilesInDirWithFilter(file, fileName));
        }
        return list;
    }

    public static boolean writeFileFromIS(String filePath, InputStream is, boolean append) {
        return FileUtil.writeFileFromIS(FileUtil.getFileByPath(filePath), is, append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileFromIS(File file, InputStream is, boolean append) {
        boolean bl;
        if (file == null || is == null) {
            return false;
        }
        if (!FileUtil.createOrExistsFile(file)) {
            return false;
        }
        BufferedOutputStream os = null;
        try {
            int len;
            os = new BufferedOutputStream(new FileOutputStream(file, append));
            byte[] data = new byte[1024];
            while ((len = is.read(data, 0, 1024)) != -1) {
                ((OutputStream)os).write(data, 0, len);
            }
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                e.printStackTrace();
                bl2 = false;
            }
            catch (Throwable throwable) {
                FileUtil.closeIO(is, os);
                throw throwable;
            }
            FileUtil.closeIO(is, os);
            return bl2;
        }
        FileUtil.closeIO(is, os);
        return bl;
    }

    public static boolean writeFileFromString(String filePath, String content, boolean append) {
        return FileUtil.writeFileFromString(FileUtil.getFileByPath(filePath), content, append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileFromString(File file, String content, boolean append) {
        boolean bl;
        if (file == null || content == null) {
            return false;
        }
        if (!FileUtil.createOrExistsFile(file)) {
            return false;
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file, append);
            fileWriter.write(content);
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                e.printStackTrace();
                bl2 = false;
            }
            catch (Throwable throwable) {
                FileUtil.closeIO(fileWriter);
                throw throwable;
            }
            FileUtil.closeIO(fileWriter);
            return bl2;
        }
        FileUtil.closeIO(fileWriter);
        return bl;
    }

    public static String getFileCharsetSimple(String filePath) {
        return FileUtil.getFileCharsetSimple(FileUtil.getFileByPath(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileCharsetSimple(File file) {
        int p = 0;
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            p = (((InputStream)is).read() << 8) + ((InputStream)is).read();
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                FileUtil.closeIO(is);
                throw throwable;
            }
            FileUtil.closeIO(is);
        }
        FileUtil.closeIO(is);
        switch (p) {
            case 61371: {
                return "UTF-8";
            }
            case 65534: {
                return "Unicode";
            }
            case 65279: {
                return "UTF-16BE";
            }
        }
        return "GBK";
    }

    public static int getFileLines(String filePath) {
        return FileUtil.getFileLines(FileUtil.getFileByPath(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFileLines(File file) {
        int count = 1;
        BufferedInputStream is = null;
        try {
            int readChars;
            is = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[1024];
            while ((readChars = ((InputStream)is).read(buffer, 0, 1024)) != -1) {
                for (int i = 0; i < readChars; ++i) {
                    if (buffer[i] != 10) continue;
                    ++count;
                }
            }
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                FileUtil.closeIO(is);
                throw throwable;
            }
            FileUtil.closeIO(is);
        }
        FileUtil.closeIO(is);
        return count;
    }

    public static List<String> readFile2List(String filePath, String charsetName) {
        return FileUtil.readFile2List(FileUtil.getFileByPath(filePath), charsetName);
    }

    public static List<String> readFile2List(File file, String charsetName) {
        return FileUtil.readFile2List(file, 0, Integer.MAX_VALUE, charsetName);
    }

    public static List<String> readFile2List(String filePath, int st, int end, String charsetName) {
        return FileUtil.readFile2List(FileUtil.getFileByPath(filePath), st, end, charsetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFile2List(File file, int st, int end, String charsetName) {
        ArrayList<String> arrayList;
        if (file == null) {
            return null;
        }
        if (st > end) {
            return null;
        }
        BufferedReader reader = null;
        try {
            String line;
            ArrayList<String> list = new ArrayList<String>();
            reader = StringUtils.isEmpty((CharSequence)charsetName) ? new BufferedReader(new FileReader(file)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
            for (int curLine = 1; (line = reader.readLine()) != null && curLine <= end; ++curLine) {
                if (st > curLine || curLine > end) continue;
                list.add(line);
            }
            arrayList = list;
        }
        catch (IOException e) {
            List<String> list;
            try {
                e.printStackTrace();
                list = null;
            }
            catch (Throwable throwable) {
                FileUtil.closeIO(reader);
                throw throwable;
            }
            FileUtil.closeIO(reader);
            return list;
        }
        FileUtil.closeIO(reader);
        return arrayList;
    }

    public static String readFile2String(String filePath, String charsetName) {
        return FileUtil.readFile2String(FileUtil.getFileByPath(filePath), charsetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile2String(File file, String charsetName) {
        String string;
        if (file == null) {
            return null;
        }
        BufferedReader reader = null;
        try {
            String line;
            StringBuilder sb = new StringBuilder();
            reader = StringUtils.isEmpty((CharSequence)charsetName) ? new BufferedReader(new InputStreamReader(new FileInputStream(file))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\r\n");
            }
            string = sb.delete(sb.length() - 2, sb.length()).toString();
        }
        catch (IOException e) {
            String string2;
            try {
                e.printStackTrace();
                string2 = null;
            }
            catch (Throwable throwable) {
                FileUtil.closeIO(reader);
                throw throwable;
            }
            FileUtil.closeIO(reader);
            return string2;
        }
        FileUtil.closeIO(reader);
        return string;
    }

    public static byte[] readFile2Bytes(String filePath) {
        return FileUtil.readFile2Bytes(FileUtil.getFileByPath(filePath));
    }

    public static byte[] readFile2Bytes(File file) {
        if (file == null) {
            return null;
        }
        try {
            return FileUtils.readFileToByteArray((File)file);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getFileSize(String filePath) {
        return FileUtil.getFileSize(FileUtil.getFileByPath(filePath));
    }

    public static String getFileSize(File file) {
        if (!FileUtil.isFileExists(file)) {
            return "";
        }
        return FileUtils.byteCountToDisplaySize((long)file.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] encryptMD5File(File file) {
        byte[] byArray;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            FileChannel channel = fis.getChannel();
            MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(buffer);
            byArray = md.digest();
        }
        catch (IOException | NoSuchAlgorithmException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                FileUtil.closeIO(fis);
                throw throwable;
            }
            FileUtil.closeIO(fis);
            return null;
        }
        FileUtil.closeIO(fis);
        return byArray;
    }

    public static void closeIO(Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        try {
            for (Closeable closeable : closeables) {
                if (closeable == null) continue;
                closeable.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getDirName(File file) {
        if (file == null) {
            return null;
        }
        return FileUtil.getDirName(file.getPath());
    }

    public static String getDirName(String filePath) {
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            return filePath;
        }
        int lastSep = filePath.lastIndexOf(File.separator);
        return lastSep == -1 ? "" : filePath.substring(0, lastSep + 1);
    }

    public static String getFileName(File file) {
        if (file == null) {
            return null;
        }
        return FileUtil.getFileName(file.getPath());
    }

    public static String getFileName(String filePath) {
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            return filePath;
        }
        int lastSep = filePath.lastIndexOf(File.separator);
        return lastSep == -1 ? filePath : filePath.substring(lastSep + 1);
    }

    public static String getFileNameNoExtension(File file) {
        if (file == null) {
            return null;
        }
        return FileUtil.getFileNameNoExtension(file.getPath());
    }

    public static String getFileNameNoExtension(String filePath) {
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            return filePath;
        }
        int lastPoi = filePath.lastIndexOf(46);
        int lastSep = filePath.lastIndexOf(File.separator);
        if (lastSep == -1) {
            return lastPoi == -1 ? filePath : filePath.substring(0, lastPoi);
        }
        if (lastPoi == -1 || lastSep > lastPoi) {
            return filePath.substring(lastSep + 1);
        }
        return filePath.substring(lastSep + 1, lastPoi);
    }

    public static String getFileExtension(File file) {
        if (file == null) {
            return null;
        }
        return FileUtil.getFileExtension(file.getPath());
    }

    public static String getFileExtension(String filePath) {
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            return filePath;
        }
        int lastPoi = filePath.lastIndexOf(46);
        int lastSep = filePath.lastIndexOf(File.separator);
        if (lastPoi == -1 || lastSep >= lastPoi) {
            return "";
        }
        return filePath.substring(lastPoi);
    }
}

