/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.utils.io;

import com.google.common.io.Files;
import com.rocoinfo.utils.base.Platform;
import com.rocoinfo.utils.text.StringUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class PathUtil {
    public static String removeQueryStringPageNumber(String queryString) {
        if (StringUtils.isNotBlank((CharSequence)queryString)) {
            return queryString.replaceAll("(^|&)pageNumber=(\\d*?)(&|$)", "$1").replaceAll("&$", "");
        }
        return "";
    }

    private static String resolveUrlQueryString(String strURL) {
        String strAllParam = null;
        String[] arrSplit = strURL.split("[?]");
        if (strURL.length() > 1 && arrSplit.length > 1 && arrSplit[1] != null) {
            strAllParam = arrSplit[1];
        }
        return strAllParam;
    }

    public static Map<String, String> resolveQueryStringToMap(String url) {
        String[] arrSplit;
        HashMap<String, String> mapRequest = new HashMap<String, String>();
        String strUrlParam = PathUtil.resolveUrlQueryString(url);
        if (strUrlParam == null) {
            return mapRequest;
        }
        for (String strSplit : arrSplit = strUrlParam.split("[&]")) {
            String[] arrSplitEqual = strSplit.split("[=]");
            if (arrSplitEqual.length > 1) {
                mapRequest.put(arrSplitEqual[0], arrSplitEqual[1]);
                continue;
            }
            if ("".equals(arrSplitEqual[0])) continue;
            mapRequest.put(arrSplitEqual[0], "");
        }
        return mapRequest;
    }

    public static String normalizePath(String path) {
        if (Platform.FILE_PATH_SEPARATOR_CHAR == '\\' && StringUtils.indexOf((CharSequence)path, (int)47) != -1) {
            return StringUtils.replaceChars((String)path, (char)'/', (char)'\\');
        }
        return path;
    }

    public static String simplifyPath(String path) {
        return Files.simplifyPath((String)path);
    }

    public static String concat(String baseName, String ... appendName) {
        if (appendName.length == 0) {
            return baseName;
        }
        StringBuilder concatName = new StringBuilder();
        if (StringUtils.endsWith((CharSequence)baseName, (CharSequence)String.valueOf(Platform.FILE_PATH_SEPARATOR_CHAR))) {
            concatName.append(baseName).append(appendName[0]);
        } else {
            concatName.append(baseName).append(Platform.FILE_PATH_SEPARATOR_CHAR).append(appendName[0]);
        }
        if (appendName.length > 1) {
            for (int i = 1; i < appendName.length; ++i) {
                concatName.append(Platform.FILE_PATH_SEPARATOR_CHAR).append(appendName[i]);
            }
        }
        return concatName.toString();
    }

    public static String getParentPath(String path) {
        String parentPath = path;
        if (Platform.FILE_PATH_SEPARATOR.equals(parentPath)) {
            return parentPath;
        }
        int idx = (parentPath = StringUtil.removeEnd(parentPath, Platform.FILE_PATH_SEPARATOR_CHAR)).lastIndexOf(Platform.FILE_PATH_SEPARATOR_CHAR);
        parentPath = idx >= 0 ? parentPath.substring(0, idx + 1) : Platform.FILE_PATH_SEPARATOR;
        return parentPath;
    }

    public static String getJarPath(Class<?> clazz) {
        return clazz.getProtectionDomain().getCodeSource().getLocation().getFile();
    }
}

