/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.utils.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.util.JSONPObject;
import com.rocoinfo.utils.mapper.JsonMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;

public class JsonUtil {
    public static final String JSON_TYPE = "application/json";
    public static final ObjectMapper mapper = JsonMapper.nonNullMapper().getMapper();

    private JsonUtil() {
    }

    public static Map<String, Object> toMap(Object pojo) {
        if (pojo instanceof Map) {
            return (Map)pojo;
        }
        try {
            return PropertyUtils.describe((Object)pojo);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toJsonP(String functionName, Object obj) {
        return JsonUtil.toJson(new JSONPObject(functionName, obj));
    }

    public static String toJson(Object obj) {
        String json;
        if (obj == null) {
            return "";
        }
        try {
            json = mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            return "";
        }
        return json;
    }

    public static <T> T fromJson(String json, Class<T> pojoClass) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            return (T)mapper.readValue(json, pojoClass);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <K, V> Map<K, V> fromJsonAsMap(String json, Class<K> keyClass, Class<V> valueClass) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return new HashMap();
        }
        MapType type = mapper.getTypeFactory().constructMapType(Map.class, keyClass, valueClass);
        try {
            Map map = (Map)mapper.readValue(json, (JavaType)type);
            return map;
        }
        catch (IOException e) {
            return new HashMap();
        }
    }

    public static <T> List<T> fromJsonAsList(String json, Class<T> pojoClass) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return Collections.emptyList();
        }
        CollectionType type = mapper.getTypeFactory().constructCollectionType(List.class, pojoClass);
        try {
            return (List)mapper.readValue(json, (JavaType)type);
        }
        catch (IOException e) {
            return null;
        }
    }

    public <T> T fromJson(String jsonString, JavaType javaType) {
        if (StringUtils.isEmpty((CharSequence)jsonString)) {
            return null;
        }
        try {
            return (T)mapper.readValue(jsonString, javaType);
        }
        catch (IOException e) {
            return null;
        }
    }

    public JavaType contructCollectionType(Class<? extends Collection> collectionClass, Class<?> elementClass) {
        return mapper.getTypeFactory().constructCollectionType(collectionClass, elementClass);
    }

    public JavaType contructMapType(Class<? extends Map> mapClass, Class<?> keyClass, Class<?> valueClass) {
        return mapper.getTypeFactory().constructMapType(mapClass, keyClass, valueClass);
    }
}

