/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.utils.net;

import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public final class IpUtil {
    public static String getRealIp(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (StringUtils.isNotBlank((CharSequence)ip)) {
            String[] ips = ip.trim().split(",");
            ip = ips[0].trim();
        }
        return ip;
    }

    public static String toIpString(InetAddress address) {
        return InetAddresses.toAddrString((InetAddress)address);
    }
}

