/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.utils.reflect;

import com.rocoinfo.utils.reflect.ClassUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;

public class AnnotationUtil {
    public static Set<Annotation> getAllAnnotations(Class<?> cls) {
        List<Class<?>> allTypes = ClassUtil.getAllSuperclasses(cls);
        allTypes.addAll(ClassUtil.getAllInterfaces(cls));
        allTypes.add(cls);
        HashSet<Annotation> anns = new HashSet<Annotation>();
        for (Class<?> type : allTypes) {
            anns.addAll(Arrays.asList(type.getDeclaredAnnotations()));
        }
        HashSet<Annotation> superAnnotations = new HashSet<Annotation>();
        for (Annotation ann : anns) {
            AnnotationUtil.getSuperAnnotations(ann.annotationType(), superAnnotations);
        }
        anns.addAll(superAnnotations);
        return anns;
    }

    private static <A extends Annotation> void getSuperAnnotations(Class<A> annotationType, Set<Annotation> visited) {
        Annotation[] anns;
        for (Annotation ann : anns = annotationType.getDeclaredAnnotations()) {
            if (ann.annotationType().getName().startsWith("java.lang") || !visited.add(ann)) continue;
            AnnotationUtil.getSuperAnnotations(ann.annotationType(), visited);
        }
    }

    public static <T extends Annotation> Set<Field> getAnnotatedPublicFields(Class<? extends Object> clazz, Class<T> annotation) {
        Field[] fields;
        if (Object.class.equals(clazz)) {
            return Collections.emptySet();
        }
        HashSet<Field> annotatedFields = new HashSet<Field>();
        for (Field field : fields = clazz.getFields()) {
            if (field.getAnnotation(annotation) == null) continue;
            annotatedFields.add(field);
        }
        return annotatedFields;
    }

    public static <T extends Annotation> Set<Field> getAnnotatedFields(Class<? extends Object> clazz, Class<T> annotation) {
        Field[] fields;
        if (Object.class.equals(clazz)) {
            return Collections.emptySet();
        }
        HashSet<Field> annotatedFields = new HashSet<Field>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (field.getAnnotation(annotation) == null) continue;
            annotatedFields.add(field);
        }
        annotatedFields.addAll(AnnotationUtil.getAnnotatedFields(clazz.getSuperclass(), annotation));
        return annotatedFields;
    }

    public static <T extends Annotation> Set<Method> getAnnotatedPublicMethods(Class<?> clazz, Class<T> annotation) {
        Method[] methods;
        if (Object.class.equals(clazz)) {
            return Collections.emptySet();
        }
        List ifcs = ClassUtils.getAllInterfaces(clazz);
        HashSet<Method> annotatedMethods = new HashSet<Method>();
        for (Method method : methods = clazz.getMethods()) {
            if (method.getAnnotation(annotation) == null && !AnnotationUtil.searchOnInterfaces(method, annotation, ifcs)) continue;
            annotatedMethods.add(method);
        }
        return annotatedMethods;
    }

    private static <T extends Annotation> boolean searchOnInterfaces(Method method, Class<T> annotationType, List<Class<?>> ifcs) {
        for (Class<?> iface : ifcs) {
            try {
                Method equivalentMethod = iface.getMethod(method.getName(), method.getParameterTypes());
                if (equivalentMethod.getAnnotation(annotationType) == null) continue;
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return false;
    }
}

