/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.utils.reflect;

import com.rocoinfo.utils.base.ExceptionUtil;
import com.rocoinfo.utils.base.ObjectUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReflectionUtil {
    private static final String SETTER_PREFIX = "set";
    private static final String GETTER_PREFIX = "get";
    private static final String IS_PREFIX = "is";
    private static final Logger log = LoggerFactory.getLogger(ReflectionUtil.class);

    public static Method getSetterMethod(Class<?> clazz, String propertyName, Class<?> parameterType) {
        String setterMethodName = SETTER_PREFIX + StringUtils.capitalize((String)propertyName);
        return ReflectionUtil.getMethod(clazz, setterMethodName, parameterType);
    }

    public static Method getGetterMethod(Class<?> clazz, String propertyName) {
        String getterMethodName = GETTER_PREFIX + StringUtils.capitalize((String)propertyName);
        Method method = ReflectionUtil.getMethod(clazz, getterMethodName, new Class[0]);
        if (method == null) {
            getterMethodName = IS_PREFIX + StringUtils.capitalize((String)propertyName);
            method = ReflectionUtil.getMethod(clazz, getterMethodName, new Class[0]);
        }
        return method;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Method method = MethodUtils.getMatchingMethod(clazz, (String)methodName, (Class[])parameterTypes);
        if (method != null) {
            ReflectionUtil.makeAccessible(method);
        }
        return method;
    }

    public static Method getAccessibleMethodByName(Class clazz, String methodName) {
        Validate.notNull((Object)clazz, (String)"clazz can't be null", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)methodName, (String)"methodName can't be blank", (Object[])new Object[0]);
        for (Class searchType = clazz; searchType != Object.class; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                ReflectionUtil.makeAccessible(method);
                return method;
            }
        }
        return null;
    }

    public static <T> T invokeGetter(Object obj, String propertyName) {
        Method method = ReflectionUtil.getGetterMethod(obj.getClass(), propertyName);
        return ReflectionUtil.invokeMethod(obj, method, new Object[0]);
    }

    public static void invokeSetter(Object obj, String propertyName, Object value) {
        Method method = ReflectionUtil.getSetterMethod(obj.getClass(), propertyName, value.getClass());
        if (method == null) {
            throw new IllegalArgumentException("Could not find getter method [" + propertyName + "] on target [" + obj + ']');
        }
        ReflectionUtil.invokeMethod(obj, method, value);
    }

    public static <T> T invokeMethod(Object obj, String methodName, Object ... args) {
        Object[] theArgs = ArrayUtils.nullToEmpty((Object[])args);
        Class[] parameterTypes = ClassUtils.toClass((Object[])theArgs);
        return ReflectionUtil.invokeMethod(obj, methodName, theArgs, parameterTypes);
    }

    public static <T> T invokeMethod(Object obj, String methodName, Object[] args, Class<?>[] parameterTypes) {
        Method method = ReflectionUtil.getMethod(obj.getClass(), methodName, parameterTypes);
        if (method == null) {
            throw new IllegalArgumentException("Could not find method [" + methodName + "] with parameter types:" + ObjectUtil.toPrettyString(parameterTypes) + " on class [" + obj.getClass() + ']');
        }
        return ReflectionUtil.invokeMethod(obj, method, args);
    }

    public static <T> T invokeMethodByName(Object obj, String methodName, Object[] args) {
        Method method = ReflectionUtil.getAccessibleMethodByName(obj.getClass(), methodName);
        if (method == null) {
            throw new IllegalArgumentException("Could not find method [" + methodName + "] on class [" + obj.getClass() + ']');
        }
        return ReflectionUtil.invokeMethod(obj, method, args);
    }

    public static <T> T invokeMethod(Object obj, Method method, Object ... args) {
        try {
            return (T)method.invoke(obj, args);
        }
        catch (Exception e) {
            throw ExceptionUtil.unwrapAndUnchecked(e);
        }
    }

    public static <T> T invokeConstructor(Class<T> cls, Object ... args) {
        try {
            return (T)ConstructorUtils.invokeConstructor(cls, (Object[])args);
        }
        catch (Exception e) {
            throw ExceptionUtil.unwrapAndUnchecked(e);
        }
    }

    public static <T> T getFieldValue(Object obj, String fieldName) {
        Field field = ReflectionUtil.getField(obj, fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + fieldName + "] on target [" + obj + "]");
        }
        return ReflectionUtil.getFieldValue(obj, field);
    }

    public static <T> T getFieldValue(Object obj, Field field) {
        try {
            return (T)field.get(obj);
        }
        catch (Exception e) {
            throw ReflectionUtil.convertReflectionExceptionToUnchecked(e);
        }
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) {
        Field field = ReflectionUtil.getField(obj, fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + fieldName + "] on target [" + obj + "]");
        }
        ReflectionUtil.setField(obj, field, value);
    }

    public static void setField(Object obj, Field field, Object value) {
        try {
            field.set(obj, value);
        }
        catch (Exception e) {
            throw ReflectionUtil.convertReflectionExceptionToUnchecked(e);
        }
    }

    public static Field getField(Object obj, String fieldName) {
        ReflectionUtil.assertNotNull(obj, "object\u4e0d\u80fd\u4e3a\u7a7a");
        return ReflectionUtil.getClassField(obj.getClass(), fieldName);
    }

    public static boolean isFieldExist(Object obj, String fieldName) {
        Field field = ReflectionUtil.getField(obj, fieldName);
        return field != null;
    }

    public static Field getClassField(Class clz, String fieldName) {
        ReflectionUtil.assertHasText(fieldName, "fieldName:" + fieldName);
        for (Class superClass = clz; superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                Field field = superClass.getDeclaredField(fieldName);
                ReflectionUtil.makeAccessible(field);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    public static Method getAccessibleMethod(Object obj, String methodName, Class<?> ... parameterTypes) {
        ReflectionUtil.assertNotNull(obj, "object\u4e0d\u80fd\u4e3a\u7a7a");
        for (Class<?> superClass = obj.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                Method method = superClass.getDeclaredMethod(methodName, parameterTypes);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        return null;
    }

    public static <T> Class<T> findParameterizedType(Class<?> clazz, int index) {
        Type parameterizedType = clazz.getGenericSuperclass();
        if (!(parameterizedType instanceof ParameterizedType)) {
            parameterizedType = clazz.getSuperclass().getGenericSuperclass();
        }
        if (!(parameterizedType instanceof ParameterizedType)) {
            return null;
        }
        Type[] actualTypeArguments = ((ParameterizedType)parameterizedType).getActualTypeArguments();
        if (actualTypeArguments == null || actualTypeArguments.length == 0) {
            return null;
        }
        return (Class)actualTypeArguments[0];
    }

    public static <T> Class<T> getSuperClassGenricType(Class clazz) {
        return ReflectionUtil.getSuperClassGenricType(clazz, 0);
    }

    public static Class getSuperClassGenricType(Class clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            log.warn(clazz.getSimpleName() + "'s superclass not ParameterizedType");
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            log.warn("Index: " + index + ", Size of " + clazz.getSimpleName() + "'s Parameterized Type: " + params.length);
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            log.warn(clazz.getSimpleName() + " not set the actual class on superclass generic parameter");
            return Object.class;
        }
        return (Class)params[index];
    }

    public static void makeAccessible(Method method) {
        if (!(method.isAccessible() || Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()))) {
            method.setAccessible(true);
        }
    }

    public static void makeAccessible(Field field) {
        if (!(field.isAccessible() || Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()))) {
            field.setAccessible(true);
        }
    }

    public static RuntimeException convertReflectionExceptionToUnchecked(Exception e) {
        if (e instanceof IllegalAccessException || e instanceof IllegalArgumentException || e instanceof NoSuchMethodException) {
            return new IllegalArgumentException("Reflection Exception.", e);
        }
        if (e instanceof InvocationTargetException) {
            return new RuntimeException("Reflection Exception.", ((InvocationTargetException)e).getTargetException());
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException("Unexpected Checked Exception.", e);
    }

    private static void assertNotNull(Object obj, String message) {
        if (obj == null) {
            throw new IllegalArgumentException(message);
        }
    }

    private static void assertHasText(String str, String message) {
        if (str != null && str.length() > 0 && str.trim().length() > 0) {
            return;
        }
        throw new IllegalArgumentException(message);
    }
}

