/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.utils.text;

import com.rocoinfo.utils.base.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class StringUtil {
    public static String replaceFirst(@Nullable String s, char sub, char with) {
        if (s == null) {
            return null;
        }
        int index = s.indexOf(sub);
        if (index == -1) {
            return s;
        }
        char[] str = s.toCharArray();
        str[index] = with;
        return new String(str);
    }

    public static String replaceLast(@Nullable String s, char sub, char with) {
        if (s == null) {
            return null;
        }
        int index = s.lastIndexOf(sub);
        if (index == -1) {
            return s;
        }
        char[] str = s.toCharArray();
        str[index] = with;
        return new String(str);
    }

    public static boolean endWith(@Nullable CharSequence s, char c) {
        if (StringUtils.isEmpty((CharSequence)s)) {
            return false;
        }
        return s.charAt(s.length() - 1) == c;
    }

    public static String removeEnd(String s, char c) {
        if (StringUtil.endWith(s, c)) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static String filterQuote(String keyword) {
        if (keyword != null) {
            keyword = keyword.replaceAll("'|\u2019|\u2018|;|--|\"|\u201c|\u201d|%|(?i)\\bselect\\b|\\bdrop\\b|\\bdelete\\b|\\bexec", "");
        }
        return keyword;
    }

    public static boolean isChinese(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        return str.matches("[\u4e00-\u9fa5]+");
    }
}

