/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.utils.time;

import com.rocoinfo.utils.base.annotation.NotNull;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public class DateFormatUtil {
    public static final String YYYYMM = "yyyyMM";
    public static final String YYYY_MM = "yyyy-MM";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String YYYY_MM_DD_HH_MM = "yyyy-MM-dd HH:mm";
    public static final String HOUR_MM_SS = "HHmmss";
    public static final String HOUR_MM_SS_TIME = "HH:mm:ss";
    public static final String TIME_ZONE = "GMT+08:00";
    public static final String START_TIME = " 00:00:00";
    public static final String END_TIME = " 23:59:59";

    public static Date parseToDateTime(String strDate) {
        return DateFormatUtil.parseDate(strDate, YYYY_MM_DD_HH_MM_SS);
    }

    public static Date parseToDate(String strDate) {
        return DateFormatUtil.parseDate(strDate, YYYY_MM_DD);
    }

    public static long parseToMilliSecond(String date) {
        return DateFormatUtil.parseToMilliSecond(date, YYYY_MM_DD_HH_MM_SS);
    }

    public static long parseToMilliSecond(String date, String pattern) {
        Date dateTime = DateFormatUtil.parseDate(date, pattern);
        if (dateTime == null) {
            return 0L;
        }
        return dateTime.getTime();
    }

    public static Date parseDate(String strDate, String pattern) {
        try {
            return FastDateFormat.getInstance((String)pattern).parse(strDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static LocalDate parseToLocalDate(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime parseToLocalDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static LocalDateTime parseToLocalDateTime(String dateStr, String pattern) {
        Date date = DateFormatUtil.parseDate(dateStr, pattern);
        if (date == null) {
            return null;
        }
        return DateFormatUtil.parseToLocalDateTime(date);
    }

    public static String formatToDate(Date date) {
        return DateFormatUtil.formatDate(date, YYYY_MM_DD);
    }

    public static String formatToDateTime(Date date) {
        return DateFormatUtil.formatDate(date, YYYY_MM_DD_HH_MM_SS);
    }

    public static String formatToTime(Date date) {
        return DateFormatUtil.formatDate(date, HOUR_MM_SS_TIME);
    }

    public static String formatToDateTime(LocalDateTime dateTime) {
        return DateFormatUtil.formatLocalDateTime(dateTime, YYYY_MM_DD_HH_MM_SS);
    }

    public static String formatLocalDateTime(LocalDateTime dateTime, String pattern) {
        if (dateTime == null) {
            return "";
        }
        return dateTime.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String formatDate(String dateStr, String formatStr) {
        return new SimpleDateFormat(formatStr).format(DateFormatUtil.parseToDate(dateStr));
    }

    public static String formatDate(Date date, @NotNull String pattern) {
        return FastDateFormat.getInstance((String)pattern).format(date);
    }

    public static String formatDate(long date, @NotNull String pattern) {
        return FastDateFormat.getInstance((String)pattern).format(date);
    }

    public static String formatLocalDate(LocalDate date) {
        if (date == null) {
            return "";
        }
        return date.format(DateTimeFormatter.ofPattern(YYYY_MM_DD));
    }

    public static String formatDurationOnSecond(@NotNull Date startDate, @NotNull Date endDate) {
        return DurationFormatUtils.formatDuration((long)(endDate.getTime() - startDate.getTime()), (String)HOUR_MM_SS_TIME);
    }

    public static String formatDurationOnSecond(long durationMillis) {
        return DurationFormatUtils.formatDuration((long)durationMillis, (String)HOUR_MM_SS_TIME);
    }
}

