package com.rocoinfo.rocomall;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.ServletContext;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.web.context.ServletContextAware;

import com.rocoinfo.rocomall.utils.JsonUtils;

/**
 * 在ServletContext中设置全局变量。可以在JSP中用EL获取。例如:${ctx}
 * 
 * @author liuwei
 */
@Component
@Lazy(false)
public class PropertyHolder implements ServletContextAware {

	private static ServletContext servletContext;
	private static String imageBaseUrl;
	private static String uploadDir;
	private static String baseurl;
	// 生成的js文件存放目录
	private static String jsGenerateDir;

	private static String logisticUrl;
	private static String smsGateWay;
	private static String smsAppId;
	private static String smsAppSecret;
	private static String smsContentPrefix;
	private static String apiKey;

	// mail 发送配置
	private static String emailSender;
	private static String emailSenderPwd;
	private static String emailServer;

	// 太平洋保险，男性
	private static String insuranceMale;
	// 太平洋保险，女性
	private static String insuranceFemale;
	// 太平洋是否是测试状态
	private static boolean isTest = false;
	// 太平洋保险，显示列参数信息
	private static Map<String, List<String>> columns;

	private static String ZXB_WAP_URL;
	private static String ZXB_PC_URL;
	private static String GENERATE_QRCODE_URL;

	public void setServletContext(ServletContext ctx) {
		PropertyHolder.servletContext = ctx;
		ctx.setAttribute("ctx", ctx.getContextPath());
		ctx.setAttribute("imageBaseUrl", imageBaseUrl);
	}

	public static ServletContext getServletContext() {
		return servletContext;
	}

	public static String getSmsGateWay() {
		return PropertyHolder.smsGateWay;
	}

	public static String getSmsAppId() {
		return PropertyHolder.smsAppId;
	}

	public static String getSmsAppSecret() {
		return PropertyHolder.smsAppSecret;
	}

	public static String getSmsContentPrefix() {
		return PropertyHolder.smsContentPrefix;
	}

	public static String getLogisticUrl() {
		return PropertyHolder.logisticUrl;
	}

	/**
	 * 此BaseUrl 就是 StaticContentServlet 的url-pattern中访问路径 例如：/file/
	 */
	public static String getImageBaseUrl() {
		return PropertyHolder.imageBaseUrl;
	}

	public static String getUploadDir() {
		return PropertyHolder.uploadDir;
	}

	public static String getJsGenerateDir() {
		return PropertyHolder.jsGenerateDir;
	}

	public static String getBaseurl() {
		return PropertyHolder.baseurl;
	}

	public static String getApiKey() {
		return PropertyHolder.apiKey;
	}

	public static String getEmailSender() {
		return PropertyHolder.emailSender;
	}

	public static String getEmailSenderPwd() {
		return PropertyHolder.emailSenderPwd;
	}

	public static String getEmailServer() {
		return PropertyHolder.emailServer;
	}

	@Value("${sms.gateway}")
	public void setSmsGateWay(String smsGateway) {
		PropertyHolder.smsGateWay = smsGateway;
	}

	@Value("${sms.appId}")
	public void setSmsAppId(String smsAppId) {
		PropertyHolder.smsAppId = smsAppId;
	}

	@Value("${sms.appSecret}")
	public void setSmsAppSecret(String smsAppSecret) {
		PropertyHolder.smsAppSecret = smsAppSecret;
	}

	@Value("${sms.contentPrefix}")
	public void setSmsContentPrefix(String smsContentPrefix) {
		PropertyHolder.smsContentPrefix = smsContentPrefix;
	}

	@Value("${image.base.url}")
	public void setImageBaseUrl(String imageBaseUrl) {
		PropertyHolder.imageBaseUrl = imageBaseUrl;
	}

	@Value("${upload.dir}")
	public void setUploadDir(String uploadDir) {
		PropertyHolder.uploadDir = uploadDir;
	}

	@Value("${js.generate.dir}")
	public void setJsGenerateDir(String jsDir) {
		PropertyHolder.jsGenerateDir = jsDir;
	}

	@Value("${baseurl}")
	public void setBaseurl(String baseurl) {
		PropertyHolder.baseurl = baseurl;
	}

	@Value("${order.logisticsInfo.addr}")
	public void setLogisticUrl(String logisticUrl) {
		PropertyHolder.logisticUrl = logisticUrl;
	}

	@Value("${email.sender}")
	public void setEmailSender(String emailSender) {
		PropertyHolder.emailSender = emailSender;
	}

	@Value("${email.sender.password}")
	public void setEmailSenderPwd(String emailSenderPassword) {
		PropertyHolder.emailSenderPwd = emailSenderPassword;
	}

	@Value("${email.server}")
	public void setEmailServer(String emailServer) {
		PropertyHolder.emailServer = emailServer;
	}

	@Value("${apikey}")
	public void setApiKey(String apiKey) {
		PropertyHolder.apiKey = apiKey;
	}

	public static String getFullImageUrl(String imagePath) {
		if (imagePath == null) {
			return null;
		}
		return PropertyHolder.getImageBaseUrl() + imagePath;
	}

	static {
		disableSslVerification();
	}

	private static void disableSslVerification() {
		try {
			// Create a trust manager that does not validate certificate chains
			TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager() {
				@Override
				public java.security.cert.X509Certificate[] getAcceptedIssuers() {
					return null;
				}

				@Override
				public void checkClientTrusted(X509Certificate[] certs, String authType) {
				}

				@Override
				public void checkServerTrusted(X509Certificate[] certs, String authType) {
				}
			}};

			// Install the all-trusting trust manager
			SSLContext sc = SSLContext.getInstance("SSL");
			sc.init(null, trustAllCerts, new java.security.SecureRandom());
			HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());

			// Create all-trusting host name verifier
			HostnameVerifier allHostsValid = new HostnameVerifier() {
				@Override
				public boolean verify(String hostname, SSLSession session) {
					return true;
				}
			};

			// Install the all-trusting host verifier
			HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
		} catch (NoSuchAlgorithmException e) {
			e.printStackTrace();
		} catch (KeyManagementException e) {
			e.printStackTrace();
		}
	}

	@Value("${tpy.insurance.male}")
	public void setInsuranceMale(String insuranceMale) {
		PropertyHolder.insuranceMale = insuranceMale;
	}

	@Value("${tpy.insurance.female}")
	public void setInsuranceFemale(String insuranceFemale) {
		PropertyHolder.insuranceFemale = insuranceFemale;
	}

	public static String getInsuranceMale() {
		return PropertyHolder.insuranceMale;
	}

	public static String getInsuranceFemale() {
		return PropertyHolder.insuranceFemale;
	}

	@Value("${tpy.insurance.isTest}")
	public void setIsTest(String isTest) {
		if (StringUtils.isEmpty(isTest)) {
			isTest = "false";
		}
		PropertyHolder.isTest = Boolean.parseBoolean(isTest);
	}

	public static boolean getIsTest() {
		return PropertyHolder.isTest;
	}

	@SuppressWarnings("unchecked")
	@Value("${tpy.insurance.columns}")
	public void setColumns(String columns) {
		if (StringUtils.isEmpty(columns)) {
			columns = "{}";
		}
		PropertyHolder.columns = JsonUtils.fromJson(columns, Map.class);
	}

	public static Map<String, List<String>> getColumns() {
		return PropertyHolder.columns;
	}

	public static String getGenerateQrcodeUrl() {
		return PropertyHolder.GENERATE_QRCODE_URL;
	}

	@Value("${zxb.wap.url}")
	public void setGenerateQrcodeUrl(String generateQrcodeUrl) {
		PropertyHolder.GENERATE_QRCODE_URL = generateQrcodeUrl;
	}

	public static String getZxbWapUrl() {
		return PropertyHolder.ZXB_WAP_URL;
	}

	@Value("${zxb.wap.url}")
	public void setZxbWapUrl(String zxbWapUrl) {
		PropertyHolder.ZXB_WAP_URL = zxbWapUrl;
	}

	public static String getZxbPcUrl() {
		return PropertyHolder.ZXB_PC_URL;
	}

	@Value("${zxb.pc.url}")
	public void setZxbPcUrl(String zxbPcUrl) {
		PropertyHolder.ZXB_PC_URL = zxbPcUrl;
	}
}