package com.rocoinfo.rocomall.common.service;

import java.util.List;
import java.util.Map;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public interface IBaseService<T> {

	public T getById(Long id);

	public void insert(T entity);

	public void update(T entity);

	public void deleteById(Long id);

	public List<T> findAll();

	public Page<T> searchScrollPage(Map<String, Object> params, Pageable pageable);
}
