package com.rocoinfo.rocomall.dto;

import java.util.Date;

import org.apache.commons.collections.CollectionUtils;

import com.rocoinfo.rocomall.entity.Catalog;
import com.rocoinfo.rocomall.entity.Product;
import com.rocoinfo.rocomall.entity.ProductSpecial;
import com.rocoinfo.rocomall.entity.Sku;

/**
 * <dl>
 * <dd>描述: 前台Sku传值</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年9月16日 下午5:07:29</dd>
 * <dd>创建人： 张敏</dd>
 * </dl>
 */
public class SkuDto {

	private Long skuId;
	private String skuCode;
	private String skuName;
	private String attribute1;
	private String attribute2;
	private String attribute3;

	private Double cashAmt; // 现金价值
	private Integer cent; // 积分价值
	private Double mergeCashAmt; // 合并现金价值
	private Double mergeCent; // 合并积分价值

	private Long prodId;
	private Date listTime;
	private Long brandId;

	//sku的商品所属分类 例如",1,2,12,"
	private String catalogIds;

	//sku图片访问路径
	private String imgLoadUrl;

	public static SkuDto valueOf(Sku sku) {
		SkuDto dto = null;
		if (sku != null) {
			dto = new SkuDto();
			copyValue2Dto(dto, sku);
		}
		return dto;
	}

	public static SkuDto valueOf(ProductSpecial settingProd) {
		SkuDto dto = new SkuDto();
		Sku sku = settingProd.getSku();
		if (sku != null) {
			copyValue2Dto(dto, sku);
		}
		return dto;
	}

	private static void copyValue2Dto(SkuDto targetDto, Sku sourceSku) {
		targetDto.setSkuId(sourceSku.getId());
		targetDto.setSkuCode(sourceSku.getCode());
		targetDto.setSkuName(sourceSku.getName());
		targetDto.setAttribute1(sourceSku.getAttribute1());
		targetDto.setAttribute2(sourceSku.getAttribute2());
		targetDto.setAttribute3(sourceSku.getAttribute3());
		targetDto.setCashAmt(sourceSku.getCashAmt());
		targetDto.setCent(sourceSku.getCent());
		targetDto.setMergeCent(sourceSku.getMergeCent());
		targetDto.setMergeCashAmt(sourceSku.getMergeCashAmt());
		targetDto.setImgLoadUrl(sourceSku.getPreviewImagePath());

		Product prod = sourceSku.getProduct();
		targetDto.setProdId(prod.getId());
		targetDto.setListTime(prod.getListTime());
		if (prod.getBrand() != null) {
			targetDto.setBrandId(prod.getBrand().getId());
		}
		if (CollectionUtils.isNotEmpty(prod.getCatalogs())) {
			final String comma = ",";
			StringBuilder cateIdBuf = new StringBuilder();
			cateIdBuf.append(comma);

			for (Catalog cate : prod.getCatalogs()) {
				cateIdBuf.append(cate.getId()).append(comma);
			}

			targetDto.setCatalogIds(cateIdBuf.toString());
		}
	}

	public Long getSkuId() {
		return skuId;
	}

	public void setSkuId(Long skuId) {
		this.skuId = skuId;
	}

	public String getSkuCode() {
		return skuCode;
	}

	public void setSkuCode(String skuCode) {
		this.skuCode = skuCode;
	}

	public String getSkuName() {
		return skuName;
	}

	public void setSkuName(String skuName) {
		this.skuName = skuName;
	}

	public String getAttribute1() {
		return attribute1;
	}

	public void setAttribute1(String attribute1) {
		this.attribute1 = attribute1;
	}

	public String getAttribute2() {
		return attribute2;
	}

	public void setAttribute2(String attribute2) {
		this.attribute2 = attribute2;
	}

	public String getAttribute3() {
		return attribute3;
	}

	public void setAttribute3(String attribute3) {
		this.attribute3 = attribute3;
	}

	public Date getListTime() {
		return listTime;
	}

	public void setListTime(Date listTime) {
		this.listTime = listTime;
	}

	public Double getCashAmt() {
		return cashAmt;
	}

	public void setCashAmt(Double cashAmt) {
		this.cashAmt = cashAmt;
	}

	public Integer getCent() {
		return cent;
	}

	public void setCent(Integer cent) {
		this.cent = cent;
	}

	public Double getMergeCashAmt() {
		return mergeCashAmt;
	}

	public void setMergeCashAmt(Double mergeCashAmt) {
		this.mergeCashAmt = mergeCashAmt;
	}

	public Double getMergeCent() {
		return mergeCent;
	}

	public void setMergeCent(Double mergeCent) {
		this.mergeCent = mergeCent;
	}

	public Long getProdId() {
		return prodId;
	}

	public void setProdId(Long prodId) {
		this.prodId = prodId;
	}

	public Long getBrandId() {
		return brandId;
	}

	public void setBrandId(Long brandId) {
		this.brandId = brandId;
	}

	public String getCatalogIds() {
		return catalogIds;
	}

	public void setCatalogIds(String catalogIds) {
		this.catalogIds = catalogIds;
	}

	public String getImgLoadUrl() {
		return imgLoadUrl;
	}

	public void setImgLoadUrl(String imgLoadUrl) {
		this.imgLoadUrl = imgLoadUrl;
	}
}
