package com.rocoinfo.rocomall.entity;

/**
 *购物车Item
 */
public class CartItem  extends IdEntity{

	private static final long serialVersionUID = -6885501214262739337L;

	/**
	 * 所属用户Id
	 */
	private long userId;
	
	
	/**
	 *unitProdId单品id,即skuId
	 */
	private long unitProdId;
	
	
	private int quantity;
	
	/**
	 * 是否被用户选中进行结算
	 */
	private boolean checked;
	


	public long getUserId(){
		return userId;
	}


	public void setUserId(long userId){
		this.userId = userId;
	}

	

	public long getUnitProdId() {
		return unitProdId;
	}


	public void setUnitProdId(long unitProdId){
		this.unitProdId = unitProdId;
	}

	public int getQuantity(){
		return quantity;
	}


	public void setQuantity(int quantity){
		this.quantity = quantity;
	}


	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + (int) (unitProdId ^ (unitProdId >>> 32));
		result = prime * result + (int) (userId ^ (userId >>> 32));
		return result;
	}


	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		CartItem other = (CartItem) obj;
		if (unitProdId != other.unitProdId)
			return false;
		if (userId != other.userId)
			return false;
		return true;
	}
	

	public boolean isChecked() {
		return checked;
	}


	public void setChecked(boolean checked) {
		this.checked = checked;
	}
}