package com.rocoinfo.rocomall.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.springframework.data.annotation.Transient;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.collect.Lists;

/**
 * 商品信息
 *
 * @author weiys
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class Product extends IdEntity {

    private static final long serialVersionUID = -2385770727436538063L;

    private String name; // 产品的管理名称

    private Brand brand;

    private String promotionWord; // 促销语

    private Date listTime;

    private Date delistTime;

    private Supplier supplier;

    private SkuMeta skuMeta;

    private Description description;

    private Status status;

    private Boolean displayInlist;

    // 是否为虚拟商品
    private Boolean visual;
    // 虚拟商品的投放方式
    private PutType putType;

    @Transient
    private List<Catalog> catalogs;

    @Transient
    private List<Sku> skus;

    @Transient
    private List<ProductImage> productImages;

    private ShowStatus showStatus;

    private Double cashAmt; // 现金价值

    private Double cent; // 积分价值

    private Double mergeCashAmt; // 合并现金价值

    private Double mergeCent; // 合并积分价值

    private String keyWorld; // 关键字

    public static enum ShowStatus {
        BOTH_VISIBLE("全部可见"), PC_VISIBLE("仅PC可见"), WAP_VISIBLE("仅WAP可见");
        private String label;

        ShowStatus(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }

    public static enum Status {
        DRAFT("草稿"), // 可以修改各项信息
        AUDIT("审批中"), READY_LIST("待上架"), REFUSE("已拒绝"), LIST("已上架"), DELIST("已下架"), DISCARD("已作废");
        /*
         * 草稿 （任何未上架且非作废的被编辑都变成草稿状态） --已作废 (作废) 终极状态 --审批中 (提交审批) ----草稿 ----已拒绝
		 * (审批拒绝) ------已作废 (作废) 终极状态 ------草稿 ----待上架 (审批通过，未到上架时间) ------草稿
		 * ----已上架 (审批通过) ------已下架 (手动下架、到期下架、缺货下架) --------已上架 (上架) --------草稿
		 * (编辑)
		 */

        private String label;

        Status(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }

    public Product() {
    }

    public Product(Long id) {
        this.id = id;
    }

    public Brand getBrand() {
        return brand;
    }

    public void setBrand(Brand brand) {
        this.brand = brand;
    }

    public Supplier getSupplier() {
        return supplier;
    }

    public void setSupplier(Supplier supplier) {
        this.supplier = supplier;
    }

    public SkuMeta getSkuMeta() {
        return skuMeta;
    }

    public void setSkuMeta(SkuMeta skuMeta) {
        this.skuMeta = skuMeta;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPromotionWord() {
        return promotionWord;
    }

    public void setPromotionWord(String promotionWord) {
        this.promotionWord = promotionWord;
    }

    public Date getListTime() {
        return listTime;
    }

    public void setListTime(Date listTime) {
        this.listTime = listTime;
    }

    public Date getDelistTime() {
        return delistTime;
    }

    public void setDelistTime(Date delistTime) {
        this.delistTime = delistTime;
    }

    public List<Sku> getSkus() {
        return skus;
    }

    public void setSkus(List<Sku> skus) {
        this.skus = skus;
    }

    public Status getStatus() {
        return status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public List<ProductImage> getProductImages() {
        return productImages;
    }

    public void setProductImages(List<ProductImage> productImages) {
        this.productImages = productImages;
    }

    public void addImage(ProductImage prodImg) {
        if (prodImg != null) {
            if (this.productImages == null) {
                this.productImages = Lists.newArrayList();
            }
            productImages.add(prodImg);
        }
    }

    public Description getDescription() {
        return description;
    }

    public void setDescription(Description description) {
        this.description = description;
    }

    public List<Catalog> getCatalogs() {
        return catalogs;
    }

    public void setCatalogs(List<Catalog> catalogs) {
        this.catalogs = catalogs;
    }

    public void addCatalog(Catalog catelog) {
        if (catelog != null) {
            if (this.catalogs == null) {
                this.catalogs = new ArrayList<Catalog>();
            }
            if (!catalogs.contains(catelog)) {
                catalogs.add(catelog);
            }
        }

    }

    public ShowStatus getShowStatus() {
        return showStatus;
    }

    public void setShowStatus(ShowStatus showStatus) {
        this.showStatus = showStatus;
    }

    public Double getCashAmt() {
        return cashAmt;
    }

    public void setCashAmt(Double cashAmt) {
        this.cashAmt = cashAmt;
    }

    public Double getCent() {
        return cent;
    }

    public void setCent(Double cent) {
        this.cent = cent;
    }

    public Double getMergeCashAmt() {
        return mergeCashAmt;
    }

    public void setMergeCashAmt(Double mergeCashAmt) {
        this.mergeCashAmt = mergeCashAmt;
    }

    public Double getMergeCent() {
        return mergeCent;
    }

    public void setMergeCent(Double mergeCent) {
        this.mergeCent = mergeCent;
    }

    public String getKeyWorld() {
        return keyWorld;
    }

    public void setKeyWorld(String keyWorld) {
        this.keyWorld = keyWorld;
    }

    public Boolean getDisplayInlist() {
        return displayInlist;
    }

    public void setDisplayInlist(Boolean displayInlist) {
        this.displayInlist = displayInlist;
    }

    public Boolean getVisual() {
        return visual;
    }

    public void setVisual(Boolean visual) {
        this.visual = visual;
    }

    public enum PutType {
        MANUAL("手动发放"), AUTO("自动发放");

        private String label;

        PutType(String label) {
            this.label = label;
        }

        public String getLabel() {
            return label;
        }
    }

    public PutType getPutType() {
        return putType;
    }

    public void setPutType(PutType putType) {
        this.putType = putType;
    }
}