package com.rocoinfo.rocomall.entity.account;

import java.util.Date;

import com.rocoinfo.rocomall.entity.IdEntity;

/**
 * 管理员操作日志。
 *
 * @author liuwei
 */
@SuppressWarnings("all")
public class AdminLog extends IdEntity {
    private Long userId; //操作者ID。定时任务为null
    private User user;

    private ObjectType objectType;
    private Long objectId;
    private Action action;
    private Date actionTime;

    public static enum ObjectType {
        PRODUCT, ORDER, ACTIVITY
    }

    public static enum Action {
        DISCARD("作废"),
        SUBMIT_AUDIT("提交审批"),
        AUDIT_REFUSE("审核拒绝"),
        AUDIT_OK("审核通过"),
        DELIST("下架"),
        LIST("上架"),
        NEW("新建"),
        EDIT("编辑");

        private String label;

        Action(String label) {
            this.label = label;
        }

        public String getLabel() {
            return label;
        }
    }

    public AdminLog() {
    }

    public AdminLog(Long userId, ObjectType objectType, Long objectId, Action action) {
        this.userId = userId;
        this.objectType = objectType;
        this.objectId = objectId;
        this.action = action;
        this.actionTime = new Date();
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public ObjectType getObjectType() {
        return objectType;
    }

    public void setObjectType(ObjectType objectType) {
        this.objectType = objectType;
    }

    public Long getObjectId() {
        return objectId;
    }

    public void setObjectId(Long objectId) {
        this.objectId = objectId;
    }

    public Action getAction() {
        return action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public Date getActionTime() {
        return actionTime;
    }

    public void setActionTime(Date actionTime) {
        this.actionTime = actionTime;
    }

    public User getUser() {
        return user;
    }

    public void setUser(User user) {
        this.user = user;
    }
}
