package com.rocoinfo.rocomall.entity.account;

import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;
import org.springframework.data.annotation.Transient;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.rocoinfo.rocomall.entity.Address;
import com.rocoinfo.rocomall.enumconst.Gender;

/**
 * 用户
 * 
 * @author zhangmin
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class User extends Account {
	private static final long serialVersionUID = -4563718697960955312L;

	/** 绑定的手机号 **/
	private String mobilePhone;

	/** 成长值,等级 **/
	private Integer growth;

	private String email;
	private EmailVerify emailVerify;

	private Date registerDate;
	private Date birthday;
	private Gender gender;

	@Transient
	private UserLevel userLevel;
	/**
	 * 用户剩余积分
	 */
	@Transient
	private int remainCents;

	// 会员的收获地址
	@Transient
	private List<Address> addressLists;

	public User() {
	}

	public User(Long id) {
		this.id = id;
	}

	public enum EmailVerify {
		VERIFIED("已验证"), UNVERIFIED("未验证");

		EmailVerify(String label) {
			this.label = label;
		}

		private String label;

		public String getLabel() {
			return label;
		}
	}

	@Length(min = 11, max = 11, message = "手机号码必须是11位数字")
	public String getMobilePhone() {
		return mobilePhone;
	}

	public void setMobilePhone(String mobilePhone) {
		this.mobilePhone = mobilePhone;
	}

	@Email
	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public Date getRegisterDate() {
		return registerDate;
	}

	public void setRegisterDate(Date registerDate) {
		this.registerDate = registerDate;
	}

	public Date getBirthday() {
		return birthday;
	}

	public void setBirthday(Date birthday) {
		this.birthday = birthday;
	}

	public Gender getGender() {
		return gender;
	}

	public void setGender(Gender gender) {
		this.gender = gender;
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}

	public Integer getGrowth() {
		return growth;
	}

	public void setGrowth(Integer growth) {
		this.growth = growth;
	}

	public List<Address> getAddressLists() {
		return addressLists;
	}

	public void setAddressLists(List<Address> addressLists) {
		this.addressLists = addressLists;
	}

	public EmailVerify getEmailVerify() {
		return emailVerify;
	}

	public void setEmailVerify(EmailVerify emailVerify) {
		this.emailVerify = emailVerify;
	}

	public int getRemainCents() {
		return remainCents;
	}

	public void setRemainCents(int remainCents) {
		this.remainCents = remainCents;
	}

	public UserLevel getUserLevel() {
		return userLevel;
	}

	public void setUserLevel(UserLevel userLevel) {
		this.userLevel = userLevel;
	}
}