package com.rocoinfo.rocomall.entity.account;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.rocoinfo.rocomall.PropertyHolder;
import com.rocoinfo.rocomall.entity.IdEntity;

/**
 * <dl>
 * <dd>描述: 会员等级</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年8月4日 下午1:31:22</dd>
 * <dd>创建人： 张敏</dd>
 * </dl>
 */
public class UserLevel extends IdEntity {

	private static final long serialVersionUID = -6920844337696530958L;
	private String level;
	private int cent;

	// 该等级会员购物时,折扣
	private double discount;

	// 会员等级Icon
	@JsonIgnore
	private String imgUrl;

	public String getLevel() {
		return level;
	}

	public void setLevel(String level) {
		this.level = level;
	}

	public int getCent() {
		return cent;
	}

	public void setCent(int cent) {
		this.cent = cent;
	}

	public double getDiscount() {
		return discount;
	}

	public void setDiscount(double discount) {
		this.discount = discount;
	}

	public String getImgUrl() {
		return imgUrl;
	}

	public void setImgUrl(String imgUrl) {
		this.imgUrl = imgUrl;
	}

	public String getFullImagePath() {
		return PropertyHolder.getFullImageUrl(imgUrl);
	}

	public double getRealDiscount() {
		return discount == 0 ? 1 : discount / 100;
	}
}