package com.rocoinfo.rocomall.entity.cent;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.entity.account.AdminUser;

/**
 * @author yuzhe
 */
public class CentApply extends IdEntity implements Cloneable{

    private static final long serialVersionUID = -6078922998035379517L;

    private AdminUser user;

    //规则编码
    private String ruleCode;

    private Integer totalCent;

    private Integer totalRecord;

    @JsonFormat(pattern = "yyyy-MM-dd hh:mm:ss", timezone = "GMT+8")
    private Date operateTime;

    private Type type;

    private Cents cents;

    private Date createTime;

    private Date updateTime;
    
    public enum Type {

        IMPORT("导入积分"), ADD("增加积分");

        private final String label;

        Type(String label) {
            this.label = label;
        }

        public String getLabel() {
            return label;
        }
    }


    public AdminUser getUser() {
        return user;
    }

    public void setUser(AdminUser user) {
        this.user = user;
    }

    public String getRuleCode() {
        return ruleCode;
    }

    public void setRuleCode(String ruleCode) {
        this.ruleCode = ruleCode;
    }

    public Integer getTotalCent() {
        return totalCent;
    }

    public void setTotalCent(Integer totalCent) {
        this.totalCent = totalCent;
    }

    public Integer getTotalRecord() {
        return totalRecord;
    }

    public void setTotalRecord(Integer totalRecord) {
        this.totalRecord = totalRecord;
    }

    public Date getOperateTime() {
        return operateTime;
    }

    public void setOperateTime(Date operateTime) {
        this.operateTime = operateTime;
    }

    public Type getType() {
        return type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

	public Cents getCents() {
		return cents;
	}

	public void setCents(Cents cents) {
		this.cents = cents;
	}

	@Override
	public Object clone(){
		CentApply centApply = null;
		try {
			centApply = (CentApply)super.clone();
		} catch (CloneNotSupportedException e) {
			return new CentApply();
		}
		return centApply;
	}

}