package com.rocoinfo.rocomall.entity.cfg;

import java.util.List;

import org.springframework.data.annotation.Transient;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.entity.cent.CentRule;

/**
 * <dl>
 * <dd>描述: 签到规则配置</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年12月15日 下午2:25:54</dd>
 * <dd>创建人： 张敏</dd>
 * </dl>
 */
public class SigninRuleCfg extends IdEntity {

	private static final long serialVersionUID = 5214099067428536041L;

	private String code;

	private String name;

	/** 连续签到周期(天数) **/
	private Integer dayCycle;

	/**
	 * 赠送积分配置项 Json cfgItemList的Json
	 */
	@JsonIgnore
	private String centCfgJson;

	@Transient
	private List<CentCfgItem> cfgItemList;

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Integer getDayCycle() {
		return dayCycle;
	}

	public void setDayCycle(Integer dayCycle) {
		this.dayCycle = dayCycle;
	}

	public String getCentCfgJson() {
		return centCfgJson;
	}

	public void setCentCfgJson(String centCfgJson) {
		this.centCfgJson = centCfgJson;
	}

	public List<CentCfgItem> getCfgItemList() {
		return cfgItemList;
	}

	public void setCfgItemList(List<CentCfgItem> cfgItemList) {
		this.cfgItemList = cfgItemList;
	}

	public static final class CentCfgItem implements Comparable<CentCfgItem> {

		//连续签到天数
		private Integer day;

		//所使用的 积分规则
		private CentRule rule;

		public CentCfgItem() {
		}

		public CentCfgItem(Integer day, CentRule rule) {
			this.day = day;
			this.rule = rule;
		}

		public Integer getDay() {
			return day;
		}

		public void setDay(Integer day) {
			this.day = day;
		}

		public CentRule getRule() {
			return rule;
		}

		public void setRule(CentRule rule) {
			this.rule = rule;
		}

		@Override
		public int compareTo(CentCfgItem o) {
			return this.day - o.getDay();
		}
	}
}
