package com.rocoinfo.rocomall.entity.dict;

import org.apache.commons.lang3.StringUtils;

import com.rocoinfo.rocomall.entity.IdEntity;

/**
 * @author weiys
 */
public class DictPlatform extends IdEntity {

	private static final long serialVersionUID = -7933190614470253973L;

	//积分平台编码
	public static final DictPlatform CENT_PLATFORM = new DictPlatform("caimipai");

	private String code;

	private String name;

	//新华其他平台账号在积分平台绑定成功后，异步通知新华地址
	private String bindNotifyUrl;

	//跳转去新华的绑定地址
	private String newChinaBindUrl;

	private String iconPath;

	private Boolean visiable;

	public DictPlatform() {
	}

	public DictPlatform(String code) {
		this.code = code;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = StringUtils.trimToNull(code);
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = StringUtils.trimToNull(name);
	}

	public String getBindNotifyUrl() {
		return bindNotifyUrl;
	}

	public void setBindNotifyUrl(String bindNotifyUrl) {
		this.bindNotifyUrl = bindNotifyUrl;
	}

	public String getNewChinaBindUrl() {
		return newChinaBindUrl;
	}

	public void setNewChinaBindUrl(String newChinaBindUrl) {
		this.newChinaBindUrl = newChinaBindUrl;
	}

	public String getIconPath() {
		return iconPath;
	}

	public void setIconPath(String iconPath) {
		this.iconPath = iconPath;
	}

	public Boolean getVisiable() {
		return visiable;
	}

	public void setVisiable(Boolean visiable) {
		this.visiable = visiable;
	}

}