package com.rocoinfo.rocomall.entity.wx;

import java.util.Date;

import org.apache.commons.lang3.StringUtils;

import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.enumconst.Gender;

/**
 * 关注公共平台的 微信用户信息
 */
public class WXUser extends IdEntity {

	private static final long serialVersionUID = 2489889299693205249L;

	/**
	 * 公共平台OpenId
	 */
	private String openId;

	/**
	 * 微信用户 分组Id
	 */
	private Integer groupId;

	/**
	 * 微信昵称
	 */
	private String nickName = StringUtils.EMPTY;

	/**
	 * 用户的性别
	 */
	private Gender sex;

	/**
	 * 用户所在国家
	 */
	private String country = StringUtils.EMPTY;

	/**
	 * 用户所在省份
	 */
	private String province = StringUtils.EMPTY;

	/**
	 * 用户所在城市
	 */
	private String city = StringUtils.EMPTY;

	/**
	 * 用户头像，最后一个数值代表正方形头像大小（有0、46、64、96、132数值可选，0代表640*640正方形头像）， 用户没有头像时该项为空
	 */
	private String headImgUrl = StringUtils.EMPTY;

	/**
	 * 绑定的会员Id
	 */
	private Long boundUserId;

	/**
	 * 绑定时间:
	 */
	private Date boundTime;

	/**
	 * 关注时间（秒） 对应公共平台：如果多次关注则用最后一次关注时间
	 */
	private Date subscribeTime;

	/**
	 * 取消关注时间（秒）
	 */
	private Date unsubscribeTime;

	/**
	 * 备注名
	 */
	private String remarkName = StringUtils.EMPTY;

	/**
	 * 个人签名
	 * 
	 * @return
	 */
	private String signature = StringUtils.EMPTY;

	public String getOpenId() {
		return openId;
	}

	public void setOpenId(String openId) {
		this.openId = openId;
	}

	public boolean isBounded() {
		return boundUserId != null && this.boundTime != null;
	}

	public void setBoundTime(Date boundTime) {
		this.boundTime = boundTime;
	}

	public Integer getGroupId() {
		return groupId;
	}

	public String getRemarkName() {
		return remarkName;
	}

	public void setRemarkName(String remarkName) {
		this.remarkName = remarkName;
	}

	public String getSignature() {
		return signature;
	}

	public void setSignature(String signature) {
		this.signature = signature;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getCountry() {
		return country;
	}

	public void setCountry(String country) {
		this.country = country;
	}

	public String getHeadImgUrl() {
		return headImgUrl;
	}

	public void setHeadImgUrl(String headImgUrl) {
		this.headImgUrl = headImgUrl;
	}

	public String getNickName() {
		return nickName;
	}

	public void setNickName(String nickName) {
		this.nickName = nickName;
	}

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public Gender getSex() {
		return sex;
	}

	public void setSex(Gender sex) {
		this.sex = sex;
	}

	public Long getBoundUserId() {
		return boundUserId;
	}

	public void setBoundUserId(Long boundUserId) {
		this.boundUserId = boundUserId;
	}

	public Date getBoundTime() {
		return boundTime;
	}

	public Date getSubscribeTime() {
		return subscribeTime;
	}

	public void setSubscribeTime(Date subscribeTime) {
		this.subscribeTime = subscribeTime;
	}

	public Date getUnsubscribeTime() {
		return unsubscribeTime;
	}

	public void setUnsubscribeTime(Date unsubscribeTime) {
		this.unsubscribeTime = unsubscribeTime;
	}

	public void setGroupId(Integer groupId) {
		this.groupId = groupId;
	}

}