package com.rocoinfo.rocomall.entity.wx;

import java.util.ArrayList;
import java.util.List;

import com.rocoinfo.rocomall.enumconst.MenuEventType;

/***
 * 微信自定义菜单 （点击微信菜单相关接口传递的json) 自定义菜单最多包括3个一级菜单，每个一级菜单最多包含5个二级菜单。一级菜单最多4个汉字，二级菜单最多7个汉字
 */
public final class WxMenu {

	/**
	 * type分:"click","view"两种 view：可以直接链接到其他网址
	 **/
	private String type;

	/**
	 * 菜单名称，不超过16个字节，子菜单不超过40个字节
	 */
	private String name;

	/**
	 * 菜单KEY值，用于消息接口推送，不超过128字节[click类型必须] key的格式："act_是否是必须绑定后才能访问此菜单" act是菜单标识符 key值例如："myorder_true"
	 */
	private String key;

	/**
	 * 网页链接，用户点击菜单可打开链接[view类型必须]
	 */
	private String url;

	/**
	 * 子菜单
	 */
	private List<WxMenu> subMenuList;

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public static WxMenu valueOf(Menu menu) {
		WxMenu wxMenu = null;
		if (menu != null) {
			wxMenu = new WxMenu();
			wxMenu.setName(menu.getMenuName());
			wxMenu.setType(menu.getMenuType().toString());

			if (MenuEventType.click.equals(menu.getMenuType())) {
				String key = menu.getAct() + Menu.MENU_ACT_SEPERATOR + menu.getBoundAccess();
				wxMenu.setKey(key);
			} else {
				wxMenu.setUrl(menu.getLinkUrl());
			}
		}
		return wxMenu;
	}

	public void addSubMenu(WxMenu subMenu) {
		if (subMenu != null) {
			if (subMenuList == null) {
				subMenuList = new ArrayList<WxMenu>();
			}
			subMenuList.add(subMenu);
		}
	}

	public List<WxMenu> getSubMenuList() {
		return subMenuList;
	}

	public void setSubMenuList(List<WxMenu> subMenuList) {
		this.subMenuList = subMenuList;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}
}