package com.rocoinfo.rocomall.pay.kuaiqian;

import java.util.Date;

import org.apache.http.client.utils.DateUtils;

import com.rocoinfo.rocomall.Constants;

/**
 * 块钱支付实体类
 * <dl>
 * <dd>描述:</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>@创建时间：2015-11-2 下午5:18:17</dd>
 * <dd>@author： 张文山</dd>
 * </dl>
 */
public class KuaiQianParm {
	// 固定选择值：1、2、3 1代表UTF-8; 2代表GBK; 3代表GB2312
	private String inputCharset = "1";
	private String pageUrl;// 接叐支付结果的页面地址
	private String bgUrl;// 服务器接叐支付结果的后台地址
	private String version = "v2.0";// 网关版本 固定值：v2.0
	// 固定值：1 1代表中文显示网关页面显示诧言种类
	private String language = "1";
	private String signType = "4";// 签名类型4代表DSA戒者RSA签名方式
	private String orderId;
	private String orderAmount;// 以分为单位 比方10元，提交时金额庒为1000,商户页面显示金额可以转换成以元为单位显示
	private String orderTime;
	private String payType = "00";
	// 签名字符串 参数1={参数1}&参数2={参数2}&……&参数n={参数n}然后迚行商户私钥证书加密形成密文后迚行1024位的Base64转码。
	private String signMsg;

	public KuaiQianParm(String orderId, String orderAmount, Date orderTime) {
		this.orderId = orderId;
		this.orderAmount = orderAmount;
		this.orderTime = DateUtils.formatDate(orderTime, Constants.YYYYMMDDHHMMSS_NJOIN);
	}

	public KuaiQianParm(String orderId, String orderAmount, String bgUrl) {
		this(orderId, orderAmount, new Date());
		this.bgUrl = bgUrl;
	}

	public String getInputCharset() {
		return inputCharset;
	}

	public void setInputCharset(String inputCharset) {
		this.inputCharset = inputCharset;
	}

	public String getPageUrl() {
		return pageUrl;
	}

	public void setPageUrl(String pageUrl) {
		this.pageUrl = pageUrl;
	}

	public String getBgUrl() {
		return bgUrl;
	}

	public void setBgUrl(String bgUrl) {
		this.bgUrl = bgUrl;
	}

	public String getVersion() {
		return version;
	}

	public void setVersion(String version) {
		this.version = version;
	}

	public String getLanguage() {
		return language;
	}

	public void setLanguage(String language) {
		this.language = language;
	}

	public String getSignType() {
		return signType;
	}

	public void setSignType(String signType) {
		this.signType = signType;
	}

	public String getOrderId() {
		return orderId;
	}

	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public String getOrderAmount() {
		return orderAmount;
	}

	public void setOrderAmount(String orderAmount) {
		this.orderAmount = orderAmount;
	}

	public String getOrderTime() {
		return orderTime;
	}

	public void setOrderTime(String orderTime) {
		this.orderTime = orderTime;
	}

	public String getPayType() {
		return payType;
	}

	public void setPayType(String payType) {
		this.payType = payType;
	}

	public String getSignMsg() {
		return signMsg;
	}

	public void setSignMsg(String signMsg) {
		this.signMsg = signMsg;
	}

}
