package com.rocoinfo.rocomall.repository;


import java.io.Serializable;
import java.util.List;
import java.util.Map;

import com.rocoinfo.rocomall.common.persistence.CrudDao;
import com.rocoinfo.rocomall.entity.ActivityParticipationRecord;

/**
 * 活动参与记录Dao
 *
 * @author YUZHE
 */
@MyBatisRepository
public interface ActivityParticipationRecordDao extends CrudDao<ActivityParticipationRecord> {

    /**
     * 添加参与记录
     */
    Integer insertRecord(Map<String, Serializable> parameter);

    /**
     * 统计参与数量
     */
    Integer countParticipationAmount(Map<String, Serializable> parameter);

    /**
     * 统计参与人数
     */
    Integer countUserAmount(Map<String, Serializable> parameter);

    /**
     * 查询活动商品售出的总数量
     */
    Long queryActivityProductCount(Long activityId);

    /**
     * 插入参与活动记录
     */
    void insert(ActivityParticipationRecord record);

    /**
     * 根据用户id查询用户参与活动的纪录
     */
    List<ActivityParticipationRecord> queryActivityRecordsByUserId(Long userId);

    /**
     * 根据活动id查询活动参与记录
     */
    List<ActivityParticipationRecord> findActivityRecordByActivityId(Long activityId);

}
