package com.rocoinfo.rocomall.repository;

import java.util.List;
import java.util.Map;

import com.rocoinfo.rocomall.common.persistence.CrudDao;
import com.rocoinfo.rocomall.entity.SkuMeta;

/**
 * SKU属性名称DAO Created by robin on 14-6-12. author yangxc
 */
@MyBatisRepository
public interface SkuMetaDao extends CrudDao<SkuMeta> {

	public SkuMeta getByProductId(Long productId);

	/**
	 * 返回产品能够销售的 所有sku元数据信息
	 * 
	 * @param productId
	 *            产品Id
	 */
	public List<Map<String, String>> getProdSkuMetas(final long productId);
}