package com.rocoinfo.rocomall.repository.cent;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.rocoinfo.rocomall.common.persistence.CrudDao;
import com.rocoinfo.rocomall.entity.cent.CentConsumeDetail;
import com.rocoinfo.rocomall.entity.cent.CentConsumeRecord;
import com.rocoinfo.rocomall.repository.MyBatisRepository;

/**
 * @author weiys
 */
@MyBatisRepository
public interface CentConsumeDetailDao extends CrudDao<CentConsumeDetail>{
    List<CentConsumeDetail> findCentConsumeDetailByRecordId(final Long recordId);
    
    void incrRefundAmt(@Param("id") final Long id, @Param("refundIncrement") final Integer refundIncrement);
    
    //更新竞拍 已返分额
    void updateAuctionRefundAmtByIdIn(final List<Long> idList);
    
    
    //可以返分的积分消耗记录明细,积分过期期间时间越大，则先返回
    List<CentConsumeDetail> findCanRefundConsumeDetailByRcrdIdOrderByExpireDateDesc(final Long recordId);
    
    //竞拍退分时，查询应该各个cent退多少分
    List<CentConsumeDetail> findAuctionRefundCents(CentConsumeRecord record);
    
    List<CentConsumeDetail> findCentConsumeRecordAndDetailByCentId(final Long centId);

    void insert(List<CentConsumeDetail> record);

}