package com.rocoinfo.rocomall.repository.cent;

import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.rocoinfo.rocomall.common.persistence.CrudDao;
import com.rocoinfo.rocomall.entity.account.UserBind;
import com.rocoinfo.rocomall.entity.cent.Cents;
import com.rocoinfo.rocomall.repository.MyBatisRepository;

/**
 * @author weiys
 */
@MyBatisRepository
public interface CentsDao extends CrudDao<Cents>{
	
	int getCentBalanceByUserIdAndExpireTo(Map<String, Object> params);
	
    void incrBalanceAndUpdateToCanUse(@Param("id") long id, @Param("increment") int increment);
    
    List<String> findExistCentCodes(List<String> codeList);
    
    List<Cents> findCentsByIdIn(Long... ids);
    
    void bindAnonyCents(UserBind bindParam);
    
    int getAnonyCents(UserBind bindParam);
    
    void lockCentsByIdIn(Long... ids);
    
    Cents getByCode(String code);
 

    void batchModifyCentStatus(@Param("newStatus") Cents.Status newStatus, @Param("codeList") List<String> codeList);
    

   	//返回某个用户可以使用的全部积分
   	List<Cents> findCanUseCentOrderByExpireDateOfUser(final long userId);
   	 
   	void scheduleExpireCent(Date limitTime);

    int findAllCentHistoryTotal(Map<String, Object> parameters);

    List<Cents> findAllCentHistory(Map<String, Object> parameters);
    
    /**
	 * 根据用户ID和积分计划在用户积分中查找赠送积分次数
	 * @param userId
	 * @param planCode
	 * @return
	 */
	int existAddCentsByPlanCode(@Param("userId") long userId, @Param("planCode") String planCode);

}