package com.rocoinfo.rocomall.repository.dict.express;

import java.util.List;

import com.rocoinfo.rocomall.common.persistence.CrudDao;
import com.rocoinfo.rocomall.entity.dict.DictProviceCity;
import com.rocoinfo.rocomall.entity.dict.express.DictExpress;
import com.rocoinfo.rocomall.repository.MyBatisRepository;

/**
 * 字典数据访问DAO
 * 
 * @author nikaixuan
 */
@MyBatisRepository
public interface DictExpressDao extends CrudDao<DictExpress> {

	/**
	 * 根据快递公司ID 查询所有绑定的城市
	 * 
	 * @param id
	 * @return 2015年11月23日 下午6:22:11
	 */
	@Deprecated
	List<DictProviceCity> findAllCityById(Long id);

	/**
	 * 根据快递公司ID查询所有绑定的城市Id
	 */
	List<Long> findBoundedCityIdsById(Long id);

	/**
	 * 通过城市id查找 绑定的快递信息
	 * 
	 * @param cityIds 城市Ids
	 * @return 绑定的城市信息与快递信息
	 */
	public List<DictProviceCity> findCityExpressByBoundedCityIds(List<Long> cityIds);

	/**
	 * 根据快递公司ID 删除所有绑定的城市
	 * 
	 * @param id 2015年11月23日 下午6:22:50
	 */
	void deleteAllCitysById(Long id);

	/**
	 * 快递公司与城市绑定
	 * 
	 * @param id 快递公司ID
	 * @param citys 城市id集合 2015年11月23日 下午6:23:57
	 */
	void insertCitys(DictExpress express);
}
