package com.rocoinfo.rocomall.repository.order;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.rocoinfo.rocomall.common.persistence.CrudDao;
import com.rocoinfo.rocomall.entity.order.DistributionOrder;
import com.rocoinfo.rocomall.entity.order.MergeDistributeOrder;
import com.rocoinfo.rocomall.entity.order.OrderItem;
import com.rocoinfo.rocomall.repository.MyBatisRepository;

/**
 * <dl>
 * <dd>描述:配送单Dao</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>@创建时间：2015/11/12 17:47</dd>
 * <dd>@author：zhangmin</dd>
 * </dl>
 */
@MyBatisRepository
public interface DistributionOrderDao extends CrudDao<DistributionOrder> {

	/**
	 * 通过Id获取配送单,包括关联的订单Item，订单的配送地址信息一起查询出来
	 * 
	 * @param distriOrderIdList 配送单Id列表
	 */
	public List<DistributionOrder> findDistributeOrderWithItemAddrByIdIn(List<Long> distriOrderIdList);

	public List<Long> findDistributeOrderIdsByMergeCode(String mergeCode);

	public void batchSave(List<DistributionOrder> distributeOrderList);

	/**
	 * 更新配送单号关联的订单Item的状态为
	 * 
	 * @param distriOrderCodeList 配送单号列表
	 */
	public void updateOrderItemToDelivered(@Param("distriOrderCodeList") List<String> distriOrderCodeList,
			@Param("status") OrderItem.Status status,@Param("admStatus") OrderItem.AdmStatus admStatus,
			@Param("exported") Boolean exported);
	
	/**
	 * 更新配送单号关联的订单Item的状态	 * 
	 * @param distriOrderCodeList 配送单号列表
	 */
	public void updateOrderItemByIds(@Param("distriOrderIds") List<Long> distriOrderIds,
			@Param("status") OrderItem.Status status,@Param("admStatus") OrderItem.AdmStatus admStatus);

	/**
	 * 合并/拆分 配送单
	 * 
	 * @param distriOrderIdList
	 * @param mergeCode mergeCode为空表示拆分,不空表示合并
	 */
	public void mergeOrSplit(@Param("distriOrderIdList") List<Long> distriOrderIdList, @Param("mergeCode") String mergeCode);

	/**
	 * 搜索 满足合并条件的 配送单
	 * 
	 * @param params
	 */
	public List<MergeDistributeOrder> searchMergeDistriOrder(Map<String, Object> params);

	public Long searchTotalMergeDistriOrder(Map<String, Object> params);

	/**
	 * 更新 配送单为已导出和并更新出库单Id
	 */
	public void updateExportedAndOutstoreIds(@Param("ids") List<Long> ids, @Param("outstoreIds") List<Long> outstoreIds, @Param("exporter") Long exporter);
}
