package com.rocoinfo.rocomall.repository.workorder;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.rocoinfo.rocomall.common.persistence.CrudDao;
import com.rocoinfo.rocomall.entity.workorder.WorkOrderRefundDetail;
import com.rocoinfo.rocomall.repository.MyBatisRepository;

/**
 * <dl>
 * <dd>描述:客服工单退货记录 数据库处理</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年11月20日11:38:21</dd>
 * <dd>更新人： Johnny</dd>
 * </dl>
 */
@MyBatisRepository
public interface WorkOrderRefundDetailDao extends CrudDao<WorkOrderRefundDetail> {

	/**
	 * 统计退货工单 尚未确认收货的入库单数量
	 */
	List<Map<String, Object>> countUnReceiveNumOfWorkOrder(List<Long> workOrderIdList);

	List<WorkOrderRefundDetail> findByWorkOrderId(@Param("workOrderId") final Long workOrderId);
}
