package com.rocoinfo.rocomall.service;

import java.util.Date;
import java.util.List;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.rocoinfo.rocomall.common.service.IBaseService;
import com.rocoinfo.rocomall.entity.account.User;
import com.rocoinfo.rocomall.entity.account.UserLevel;
import com.rocoinfo.rocomall.enumconst.SwitchStatus;
import com.rocoinfo.rocomall.enumconst.TTLUnit;

/**
 * <dl>
 * <dd>描述: 会员Service</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年8月3日 下午6:41:43</dd>
 * <dd>创建人： 张敏</dd>
 * </dl>
 */
public interface IUserService extends IBaseService<User> {

    /**
     * 更新登录密码
     */
    void updateLoginPassword(final long userId, final String newPlainPwd);

    /**
     * 校验登录密码是否正确
     *
     * @param username      登录名
     * @param loginPassword 明文登录密码
     */
    boolean isLoginPasswordCorrect(final String username, final String loginPassword);

    /**
     * 判断用户名是否已经被注册
     *
     * @param username 登录用户名
     */
    boolean isUsernameRegisted(String username);

    /**
     * 成长值 和 账户积分余额不能用缓存里面的数据，因为这些数据可能实时变化
     *
     * @return 返回成长值，如果userId不存在则返回-1
     */
    int getGrowthById(Long userId);

    /**
     * 增加|减少会员的成长值
     *
     * @param userId    用户Id
     * @param increment 成长值增量,increment>0表示添加，increment<0表示减少
     */
    void increaseGrowthById(Long userId, int increment);

    /**
     * 获取某个人 剩余积分余额
     */
    int getCentBalanceByUserId(Long userId);

    /**
     * 返回还剩多少天过期的积分
     *
     * @param userId  会员Id
     * @param amount  (Time To Live) 积分还剩多少天过期
     * @param ttlDays 0 表示不限制过期天数
     */
    int getCentBalanceByUserIdAndTTL(final Long userId, final TTLUnit ttlUnit, final int amount);

    /**
     * 返回会员的会员等级
     *
     * @param userId 会员Id
     */
    UserLevel getUserLevelById(final Long userId);

    User getUserByUsername(String username);

    User getByMobile(String mobile);

    Page<User> searchUser(Date registStartDate, Date registEndDate, String userNameOrName, String mobilePhone, SwitchStatus status, Pageable pageable);

    /**
     * 绑定手机号
     *
     * @param userId 会员Id
     * @param mobile 手机号
     */
    void bindMobileByUserId(long userId, final String mobile);

    /**
     * 开通/关闭 会员
     *
     * @param userId 会员Id
     * @param status 会员状态
     */
    void switchUser(Long userId, SwitchStatus status);

    List<Long> findCatalogIdsByUserId(Long loggedUserId);

    void personalSettingsSave(User user, Long[] catalogIds);
}