package com.rocoinfo.rocomall.service.cent;

import java.util.Map;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.rocoinfo.rocomall.common.service.IBaseService;
import com.rocoinfo.rocomall.dto.DeductParam;
import com.rocoinfo.rocomall.dto.RefundParam;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.cent.Cents;

/**
 * <dl>
 * <dd>描述: </dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：15/8/28  下午3:03</dd>
 * <dd>创建人： weiys</dd>
 * </dl>
 */
public interface ICentsService extends IBaseService<Cents> {

    /**
     * 退积分
     *
     * @param refundParam
     */
    void refundCent(RefundParam refundParam);

    /**
     * 查询用户积分时间统计表的数据
     *
     * @param parameters
     * @param pageable
     * @return
     */
    Page<Cents> searchHistCents(Map<String, Object> parameters, Pageable pageable);

    /**
     * 扣分
     */
    StatusDto deductCent(DeductParam param, Long loggedUserId);
}
