package com.rocoinfo.rocomall.service.dict;

import java.util.List;
import java.util.Map;

import com.rocoinfo.rocomall.common.service.IBaseService;
import com.rocoinfo.rocomall.entity.Address;
import com.rocoinfo.rocomall.entity.dict.DictProviceCity;

/**
 * <dl>
 * <dd>描述:</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：15/8/13 上午10:36</dd>
 * <dd>创建人： weiys</dd>
 * </dl>
 */
@SuppressWarnings("all")
public interface IDictProviceCityService extends IBaseService<DictProviceCity> {

	public Map<Long, DictProviceCity> loadAllDictProvCityMap();

	/**
	 * 构建省市节点列表
	 * 
	 * @param checkedCityIdList 勾选中的城市Id,如果无需勾选情况，则传入null
	 */
	public List<DictProviceCity> buildProvCityNodes(List<Long> checkedCityIdList);

	/**
	 * @param isLoadNodeList 是否获取各层级的节点列表 构建所有祖先节点[包括自己]
	 */
	public Map<Long, List<DictProviceCity>> buildParentProvCityNodeTree(boolean isLoadNodeList, final Address... addressArray);

	public DictProviceCity getRootDictProviceCityById(final long id);

	public List<DictProviceCity> findDictProvCitysByPid(final Long pid);

	public List<DictProviceCity> loadDictProvCityList(List<Long> pids);

	/**
	 * 批量修改省市 显示顺序
	 */
	@Deprecated
	public void batchModifyProvCitySeqs(final Integer[] ids, final Integer[] seqs);

}