package com.rocoinfo.rocomall.service.impl;

import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.entity.BannerAdv;
import com.rocoinfo.rocomall.repository.AdvertiseDao;
import com.rocoinfo.rocomall.service.IAdvertiseService;
import com.rocoinfo.rocomall.service.IUploadService;


/**
 * 广告相关的 Service
 *
 * @author zhangmin
 */
@SuppressWarnings("all")
@Service
@Transactional(isolation = Isolation.REPEATABLE_READ)
public class AdvertiseService extends CrudService<AdvertiseDao,BannerAdv> implements IAdvertiseService{

    @Autowired
    private IUploadService uploadService;



    /**
     * @param visibleFlag 是否显示标志位, -1:全部   1：显示    0:关闭
     * @return 查询banner广告列表 ,返回的结果按照 displayOrder asc排序
     */
    public List<BannerAdv> findBannerAdvList(final int visibleFlag) {
        Map<String, Integer> paramMap = Maps.newHashMap();
        paramMap.put("visibleFlag", visibleFlag);
        return entityDao.findBanners(paramMap);
    }




    public void insert(final BannerAdv banner) {
        if (StringUtils.isNotBlank(banner.getImgUrl())) {
            banner.setImgUrl(uploadService.submitPath(banner.getImgUrl()));
        }
        super.insert(banner);
    }

    public void update(final BannerAdv banner) {
        BannerAdv oldBannerAdv = getById(banner.getId());
        if (oldBannerAdv == null) {
            throw new ServiceException("要修改的记录不存在. id=" + banner.getId());
        }
        if (banner.getImgUrl() != null) {
            if (!banner.getImgUrl().equals(oldBannerAdv.getImgUrl())) {
                uploadService.delete(oldBannerAdv.getImgUrl());
            }

            banner.setImgUrl(uploadService.submitPath(banner.getImgUrl()));
        }
        super.update(banner);
    }

    public void deleteById(Long advId) {
        BannerAdv bannerAdv = getById(advId);
        if (bannerAdv != null) {
            super.deleteById(advId);
            uploadService.delete(bannerAdv.getImgUrl());
        }
    }

    public void modifyBannerAdvVisibility(final boolean visible, final Integer... advIds) {
        if (!ArrayUtils.isEmpty(advIds)) {
            Map<String, Object> paramMap = Maps.newHashMap();
            paramMap.put("visible", visible);
            paramMap.put("advIds", advIds);
            entityDao.modifyBannerAdvVisibility(paramMap);
        }
    }

    /**
     * 批量修改banner广告的显示顺序
     */
    @Deprecated
    public void batchModifyBannerAdvSeq(final Integer[] advIds, final Integer[] seqs) {
        if (ArrayUtils.isEmpty(advIds) || ArrayUtils.isEmpty(seqs) || advIds.length != seqs.length) {
            throw new IllegalArgumentException("批量修改Banner广告顺序时，advIds与seqs参数都不能为空，并且数组长度必须一致");
        }

        Map<String, Object> paramMap = Maps.newHashMap();
        paramMap.put("advIds", advIds);
        paramMap.put("seqs", seqs);

        entityDao.batchModifyBannerAdvSeq(paramMap);
    }
    
    private AdvertiseService getProxy(){
        return (AdvertiseService) AopContext.currentProxy();
    }
    


}