package com.rocoinfo.rocomall.service.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.rocoinfo.rocomall.Constants;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.dto.PageRowItemList;
import com.rocoinfo.rocomall.entity.account.LoginLog;
import com.rocoinfo.rocomall.repository.account.LoginLogDao;
import com.rocoinfo.rocomall.service.ILoginLogService;

/**
 * @author zhangmin
 */
@Service
public class LoginLogService extends CrudService<LoginLogDao, LoginLog> implements ILoginLogService {

	@Autowired
	private LoginLogDao loginLogDao;

	/**
	 * 查询登录LOG
	 * 
	 * @param params
	 *            查询条件
	 * @param pageable
	 *            分页对象
	 * @return
	 */
	@Transactional(readOnly = true)
	public PageRowItemList<LoginLog> search(Map<String, Object> params, Pageable pageable) {
		Long total = loginLogDao.searchTotal(params);
		List<LoginLog> content = Collections.emptyList();

		if (total > pageable.getOffset()) {
			params.put(Constants.PAGE_OFFSET, pageable.getOffset());
			params.put(Constants.PAGE_SIZE, pageable.getPageSize());
			params.put(Constants.PAGE_SORT, pageable.getSort());

			content = loginLogDao.search(params);
		}
		return new PageRowItemList<LoginLog>(total.intValue(), content);
	}

}
