package com.rocoinfo.rocomall.service.impl.insurance;

import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.insurance.InsuredInfo;
import com.rocoinfo.rocomall.repository.insurance.InsuredInfoDao;
import com.rocoinfo.rocomall.service.insurance.IInsuredInfoService;

/**
 * <dl>
 * <dd>描述: 投保人信息</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>@创建时间：2015/12/29 15:52</dd>
 * <dd>@author：huyt</dd>
 * </dl>
 */
@Service
@Transactional
public class InsuredInfoService extends CrudService<InsuredInfoDao, InsuredInfo> implements IInsuredInfoService {

    @Override
    public InsuredInfo getByMobileOrOpenid(String username) {
        List<InsuredInfo> list = this.entityDao.findByUsername(username);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public List<InsuredInfo> findByRelationId(Long id) {
        return this.entityDao.findByRelationId(id);
    }

    @Override
    public void createUserInfo(Long id, String username) {
        if (StringUtils.isBlank(username))
            return;
        // 校验用户是否存在
        InsuredInfo hasUser = this.getByMobileOrOpenid(username);
        // 用户不存在才保存对应的关系
        if (hasUser == null)
            this.entityDao.createUserInfo(id, username);
    }

    @Override
    public void createUserRelationship(InsuredInfo loginUser, InsuredInfo relationUser, boolean isLogin) {
        if (loginUser == null || relationUser == null) {
            return;
        }
        Long loginUserId = loginUser.getId();
        Long relationId = relationUser.getId();
        if (!isLogin) { //如果用户没登录 需要检查投保人(即loginUser)的手机号是否已经注册成为系统用户,如果是,那么找出该用户并建立关联关系,否则直接建立关联关系
            InsuredInfo hasRegistUser = this.getByMobileOrOpenid(loginUser.getMobile());
            if (hasRegistUser != null) {
                loginUserId = hasRegistUser.getId();
            }
        }
        // 如果数据库中不存在关联关系 那么建立关联关系
        if (!this.hasRelation(loginUserId, relationId)) {
            this.entityDao.createUserRelationship(loginUserId, relationId);
        }
    }

    @Override
    public void saveOrUpdate(InsuredInfo insuredInfo) {
        if (insuredInfo == null)
            return;
        InsuredInfo exsistUser = this.getByCardNo(insuredInfo.getCardNo());
        if (exsistUser != null) {
            insuredInfo.setId(exsistUser.getId());
            this.update(insuredInfo);
        } else {
            this.insert(insuredInfo);
        }
    }

    @Override
    public InsuredInfo getByCardNo(String cardNo) {
        if (StringUtils.isNotBlank(cardNo)) {
            List<InsuredInfo> list = this.entityDao.findByCardNo(cardNo);
            if (list != null && list.size() > 0)
                return list.get(0);
        }
        return null;

    }

    @Override
    public boolean hasRelation(Long insuredId, Long relationId) {
        Long count = this.entityDao.getRelationCount(insuredId, relationId);
        if (count > 0)
            return true;
        return false;
    }

    @Override
    public void createNewAccount(InsuredInfo insuredInfo, String username) {
        InsuredInfo exsistAccount = this.getByMobileOrOpenid(username);
        if (exsistAccount == null) { //账户不存在
            this.insert(insuredInfo);
            this.createUserInfo(insuredInfo.getId(), username);
        }
    }

}
