package com.rocoinfo.rocomall.service.impl.order;

import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.account.User;
import com.rocoinfo.rocomall.entity.insurance.InsuredInfo;
import com.rocoinfo.rocomall.entity.order.Order;
import com.rocoinfo.rocomall.entity.order.OrderInsurance;
import com.rocoinfo.rocomall.entity.order.OrderItem.OrderType;
import com.rocoinfo.rocomall.repository.order.OrderInsuranceDao;
import com.rocoinfo.rocomall.service.insurance.IInsuredInfoService;
import com.rocoinfo.rocomall.service.order.IOrderInsuranceService;
import com.rocoinfo.rocomall.service.order.IOrderService;
import com.rocoinfo.rocomall.utils.CodeGenerator;

/**
 * <dl>
 * <dd>描述:保险保单订单</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2016年1月5日12:55:46</dd>
 * <dd>创建人： Johnny</dd>
 * </dl>
 */
@SuppressWarnings("all")
@Service
public class OrderInsuranceService extends CrudService<OrderInsuranceDao, OrderInsurance> implements IOrderInsuranceService {
	@Autowired
	private IOrderService orderService;
	@Autowired
	private IInsuredInfoService iInsuredInfoService;
	@Autowired
	private CodeGenerator codeGenerator;

	public OrderInsurance getByOrderCode(final String orderCode) {
		OrderInsurance orderInsurance = null;
		if (StringUtils.isNotBlank(orderCode)) {
			orderInsurance = entityDao.getByOrderCode(orderCode);
		}
		return orderInsurance;
	}

	@Transactional
	public void insert(final OrderInsurance orderInsurance) {
		Order order = new Order();
		order.setCreateTime(new Date());
		order.setOrderCode(codeGenerator.generateOrderCode(new Date(), OrderType.common));
		User user = new User();
		user.setId(0l);
		order.setUser(user);
		order.setDistributed(false);
		order.setLocked(false);
		order.setCashAmt(0d);
		order.setCashPayed(false);
		order.setCent(0);
		order.setCentPayed(false);
		orderService.insert(order);
		orderInsurance.setOrderCode(order.getOrderCode());
		orderInsurance.setCreateDate(new Date());
		super.insert(orderInsurance);
	}

	/**
	 * 新增保险单的同时，增加保险人和被保险人。
	 */
	@Transactional
	public void insertOrder(final OrderInsurance orderInsurance, final InsuredInfo loginUser) {
		Order order = new Order();
		order.setCreateTime(new Date());
		order.setOrderCode(codeGenerator.generateOrderCode(new Date(), OrderType.common));
		User user = new User();
		user.setId(0l);
		order.setUser(user);
		order.setDistributed(false);
		order.setLocked(false);
		order.setCashAmt(0d);
		order.setCashPayed(false);
		order.setCent(0);
		order.setCentPayed(false);
		orderService.insert(order);
		orderInsurance.setOrderCode(order.getOrderCode());
		orderInsurance.setCreateDate(new Date());
		super.insert(orderInsurance);
		// 保存被保险人
		iInsuredInfoService.saveOrUpdate(orderInsurance.getApplicant());
		// 保存投保人
		iInsuredInfoService.saveOrUpdate(orderInsurance.getInsuredInfo());

		if (loginUser != null) {
			iInsuredInfoService.createUserRelationship(loginUser, orderInsurance.getApplicant(), true);
			iInsuredInfoService.createUserRelationship(loginUser, orderInsurance.getInsuredInfo(), true);
		} else {
			iInsuredInfoService.createUserRelationship(orderInsurance.getInsuredInfo(), orderInsurance.getApplicant(), false);
			iInsuredInfoService.createUserRelationship(orderInsurance.getInsuredInfo(), orderInsurance.getInsuredInfo(), false);
		}
		// 创建账户信息
		iInsuredInfoService.createUserInfo(orderInsurance.getInsuredInfo().getId(), orderInsurance.getInsuredInfo().getMobile());
	}

	/**
	 * 根据投保人手机号，查询所有保单信息
	 * 
	 * @param mobile
	 */
	@Override
	public List<OrderInsurance> getByMobile(String mobile) {
		List<OrderInsurance> result = null;
		if (StringUtils.isNotBlank(mobile)) {
			result = entityDao.getByMobile(mobile);
		}
		return result;
	}
}