package com.rocoinfo.rocomall.service.impl.wx;

import com.rocoinfo.rocomall.Constants;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.Address;
import com.rocoinfo.rocomall.entity.insurance.InsuranceInfo;
import com.rocoinfo.rocomall.entity.wx.InsuranceByRecord;
import com.rocoinfo.rocomall.entity.wx.WXMsg;
import com.rocoinfo.rocomall.redis.JedisTemplate;
import com.rocoinfo.rocomall.repository.insurance.InsuranceInfoDao;
import com.rocoinfo.rocomall.repository.wx.InsuranceByRecordDao;
import com.rocoinfo.rocomall.repository.wx.WxMsgDao;
import com.rocoinfo.rocomall.service.IAddressService;
import com.rocoinfo.rocomall.service.wx.IHitGoldEggService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springside.modules.utils.Collections3;

import java.util.*;

/**
 * 
 * <dl>
 * <dd>描述:砸金蛋service</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>@创建时间：2015-8-11 下午5:59:08</dd>
 * <dd>@author： 张文山</dd>
 * </dl>
 */
@Service
public class HitGoldEggService extends CrudService<InsuranceByRecordDao, InsuranceByRecord> implements IHitGoldEggService {

	@Autowired
	private InsuranceInfoDao insuranceInfoDao;

	@Autowired
	private IAddressService addressService;

	@Autowired
	private JedisTemplate jedisTemplate;

	@Override
	public List<String> createPrizePool(int meta[][]){
		List<String> pool = new ArrayList<String>();
		for(int [] arr:meta){
			for(int i =0;i<arr[1];i++){
				pool.add(String.valueOf(arr[0]));
			}
		}
		Random random = new Random();
		for(int i =0;i<2;i++){
			for(int j =0;j<pool.size();j++){
				int index1 = random.nextInt(pool.size()-1);
				String temp =pool.get(index1);
				pool.set(index1, pool.get(j));
				pool.set(j, temp);
			}
		}

		String [] result =   pool.toArray(new String[pool.size()]);
		jedisTemplate.lpush(Constants.HIT_GOLD_EGG_POOL,result);
		return pool;
	}

	@Override
	public void initPrizePool(int meta[][]){
		if(meta == null){
			return ;
		}
		if(this.entityDao.getRecordCount(null)<1){
			jedisTemplate.del(Constants.HIT_GOLD_EGG_POOL);
			jedisTemplate.del(Constants.HIT_GOLD_EGG_COUNT);
			createPrizePool(meta);
		}
	}

	@Override
	public String guessGoldEggResult() {
		return jedisTemplate.lpop(Constants.HIT_GOLD_EGG_POOL);
	}

	@Override
	@Transactional(isolation = Isolation.READ_COMMITTED, propagation = Propagation.REQUIRED)
	public StatusDto hitEgg(String openId) {
		List<InsuranceByRecord>  records = this.entityDao.getHitChanceByOpenId(openId);
		if (CollectionUtils.isEmpty(records) || records.size()<1) {

			return StatusDto.buildStatusDto("不能参与","2");
		}
		if(!jedisTemplate.hasKey(Constants.HIT_GOLD_EGG_POOL)){
			int recordCount = this.entityDao.getRecordCount(openId);
			if(recordCount>0){
				return StatusDto.buildStatusDto("已经抽奖过一次","3");
			}
			return StatusDto.buildStatusDto("没有奖品了","5");
		}
		InsuranceByRecord record = Collections3.getFirst(records);
		Long index = jedisTemplate.incr(Constants.HIT_GOLD_EGG_COUNT);
		if(index %3 !=0){
			record.setGuessPrizeStatus(InsuranceByRecord.GuessPrizeStatus.NOHIT);
			this.entityDao.update(record);
			return StatusDto.buildStatusDto("没有中奖","4");
		}
		String prizeId = guessGoldEggResult();
		if(StringUtils.isBlank(prizeId)){
			record.setGuessPrizeStatus(InsuranceByRecord.GuessPrizeStatus.NOHIT);
			this.entityDao.update(record);
			return StatusDto.buildStatusDto("没有奖品了","5");
		}
		record.setGuessPrizeStatus(InsuranceByRecord.GuessPrizeStatus.HIT);
		record.setPrizeId(prizeId);
		this.entityDao.update(record);
		StatusDto<Map>  mapDto = StatusDto.buildDataSuccessStatusDto("1");
		mapDto.setData(new HashMap<String,Object>());
		mapDto.getData().put("prizeId",prizeId);
		mapDto.getData().put("recordId",record.getId());
		return mapDto;
	}

	@Override
	public List<InsuranceByRecord> getHitRecordByOpenId(String openId) {
		return this.entityDao.getHitRecordByOpenId(openId);
	}

	@Override
	@Transactional(isolation = Isolation.READ_COMMITTED, propagation = Propagation.REQUIRED)
	public void saveAddress(Address address,Long recordId) {
		addressService.insert(address);
		InsuranceByRecord record = new InsuranceByRecord();
		record.setId(recordId);
		record.setAddress(address);
		this.entityDao.update(record);
	}

	@Override
	public InsuranceByRecord getByThirdOrderId(String thirdOrderId) {
		return this.entityDao.getByThirdOrderId(thirdOrderId);
	}

	/**
	 * 支付结果反馈
	 * @param record
     */
	@Override
	public void payNotice(InsuranceByRecord record) {
		InsuranceByRecord dbRecord = getByThirdOrderId(record.getThirdOrderId());
		if(dbRecord != null){
			if(dbRecord.getPayStatus() == InsuranceByRecord.PayStatus.SUCCESS
					&& record.getPayStatus() ==InsuranceByRecord.PayStatus.FAIL){
 				throw new ServiceException("已经支付成功,无法更新");
			}
			record.setId(dbRecord.getId());
			this.update(dbRecord);
			return ;
		}

		record.setTime(new Date());
		record.setGuessPrizeStatus(InsuranceByRecord.GuessPrizeStatus.INIT);
		this.insert(record);
	}

	@Override
	public List<InsuranceInfo> getInsuranceInfo(String openId, String policyNumber) {
		return insuranceInfoDao.selectSearch(openId,policyNumber);
	}

	@Override
	public InsuranceInfo getInsuranceById(Long id) {
		return   insuranceInfoDao.getById(  id);
	}
}
