package com.rocoinfo.rocomall.service.impl.wx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.wx.Menu;
import com.rocoinfo.rocomall.repository.wx.WxMenuDao;
import com.rocoinfo.rocomall.service.wx.IWxMenuService;

/**
 * <dl>
 * <dd>描述:微信菜单 服务</dd>
 * </dl>
 */
@Service
public class WxMenuService extends CrudService<WxMenuDao, Menu> implements IWxMenuService {

	public List<Menu> findTopWithSubMenus() {
		List<Menu> topMenus = new ArrayList<Menu>();
		Map<Long, Menu> topMenuTemp = new HashMap<Long, Menu>();
		List<Menu> allMenu = this.entityDao.findAll();
		if (!allMenu.isEmpty()) {
			for (Menu menu : allMenu) {
				if (menu.getPid() == null || menu.getPid() == 0) {
					topMenus.add(menu);
					topMenuTemp.put(menu.getId(), menu);
				}
			}

			//处理submenu
			for (Menu menu : allMenu) {
				if (menu.getPid() > 0) {
					topMenuTemp.get(menu.getPid()).addChildMenu(menu);
				}
			}
		}
		return topMenus;
	}

	public void batchUpdateSeqs(List<Long> menuIdList, List<Integer> seqList) {
		if (CollectionUtils.isEmpty(menuIdList) || CollectionUtils.isEmpty(seqList) || menuIdList.size() != seqList.size()) {
			return;
		}

		this.entityDao.batchUpdateSeqs(menuIdList, seqList);
	}

	public String getMenuBoundedMessageId(int menuId) {
		return null;

	}

	public void bindMenuMessageId(String messageId, int menuId) {
		// TODO Auto-generated method stub

	}

}
