package com.rocoinfo.rocomall.service.workorder;

import com.rocoinfo.rocomall.common.service.IBaseService;
import com.rocoinfo.rocomall.entity.account.AdminUser;
import com.rocoinfo.rocomall.entity.workorder.WorkOrder;

/**
 * <dl>
 * <dd>描述:客服工单 服务</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年11月18日 上午10:34:59</dd>
 * <dd>更新人： Johnny</dd>
 * </dl>
 */
public interface IWorkOrderService extends IBaseService<WorkOrder> {

	/**
	 * 工单结案
	 * 
	 * @param workOrder 工单
	 */
	public void closeWorkOrder(WorkOrder workOrder);

	/**
	 * 生成退货工单的 入库通知单 & 更新子订单状态为 “退货已输入物流单号”
	 * 
	 * @param workOrder
	 * @param 入库操作人
	 */
	public void generateRefundInstoreOrders(WorkOrder workOrder, AdminUser operator);

}
